/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class HugeConfig
extends PropertiesConfiguration {
    private static final Logger LOG = Log.logger(HugeConfig.class);
    private String configPath;

    public HugeConfig(Configuration config) {
        this.loadConfig(config);
        this.configPath = null;
    }

    public HugeConfig(String configFile) {
        this.loadConfig(HugeConfig.loadConfigFile(configFile));
        this.configPath = configFile;
    }

    public HugeConfig(Map<String, Object> propertyMap) {
        if (propertyMap == null) {
            throw new ConfigException("The property map is null");
        }
        for (Map.Entry<String, Object> kv : propertyMap.entrySet()) {
            this.addProperty(kv.getKey(), kv.getValue());
        }
        this.checkRequiredOptions();
    }

    private void loadConfig(Configuration config) {
        if (config == null) {
            throw new ConfigException("The config object is null");
        }
        this.setLayoutIfNeeded(config);
        this.append(config);
        this.checkRequiredOptions();
    }

    private void setLayoutIfNeeded(Configuration conf) {
        if (!(conf instanceof PropertiesConfiguration)) {
            return;
        }
        PropertiesConfiguration propConf = (PropertiesConfiguration)conf;
        this.setLayout(propConf.getLayout());
    }

    public <T, R> R get(TypedOption<T, R> option) {
        Object value = this.getProperty(option.name());
        if (value == null) {
            return option.defaultValue();
        }
        return (R)value;
    }

    public Map<String, String> getMap(ConfigListOption<String> option) {
        List values = (List)this.get(option);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String value : values) {
            String[] pair = value.split(":", 2);
            E.checkState(pair.length == 2, "Invalid option format for '%s': %s(expect KEY:VALUE)", option.name(), value);
            result.put(pair[0].trim(), pair[1].trim());
        }
        return result;
    }

    public void addPropertyDirect(String key, Object value) {
        TypedOption<?, ?> option = OptionSpace.get(key);
        if (option == null) {
            LOG.warn("The config option '{}' is redundant, please ensure it has been registered", (Object)key);
        } else {
            value = this.validateOption(key, value);
        }
        if (this.containsKey(key) && value instanceof List) {
            for (Object item : (List)value) {
                super.addPropertyDirect(key, item);
            }
        } else {
            super.addPropertyDirect(key, value);
        }
    }

    protected void addPropertyInternal(String key, Object value) {
        this.addPropertyDirect(key, value);
    }

    private Object validateOption(String key, Object value) {
        TypedOption<?, ?> option = OptionSpace.get(key);
        if (value instanceof String) {
            return option.parseConvert((String)value);
        }
        Class<?> dataType = option.dataType();
        if (dataType.isInstance(value)) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Invalid value for key '%s': '%s'", key, value));
    }

    private void checkRequiredOptions() {
    }

    public void save(File copiedFile) throws ConfigurationException {
        FileHandler fileHandler = new FileHandler((FileBased)this);
        fileHandler.save(copiedFile);
    }

    @Nullable
    public File file() {
        if (StringUtils.isEmpty((CharSequence)this.configPath)) {
            return null;
        }
        return new File(this.configPath);
    }

    public void file(String path) {
        this.configPath = path;
    }

    private static Configuration loadConfigFile(String path) {
        E.checkNotNull(path, "config path");
        E.checkArgument(!path.isEmpty(), "The config path can't be empty", new Object[0]);
        File file = new File(path);
        return HugeConfig.loadConfigFile(file);
    }

    private static Configuration loadConfigFile(File configFile) {
        E.checkArgument(configFile.exists() && configFile.isFile() && configFile.canRead(), "Please specify a proper config file rather than: '%s'", configFile.toString());
        try {
            XMLConfiguration config;
            String fileName = configFile.getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            Configurations configs = new Configurations();
            switch (fileExtension) {
                case "yml": 
                case "yaml": {
                    Parameters params = new Parameters();
                    FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(YAMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.fileBased().setFile(configFile)});
                    config = (Configuration)builder.getConfiguration();
                    break;
                }
                case "xml": {
                    config = configs.xml(configFile);
                    break;
                }
                default: {
                    config = configs.properties(configFile);
                }
            }
            return config;
        }
        catch (ConfigurationException e) {
            throw new ConfigException("Unable to load config: '%s'", (Throwable)e, configFile);
        }
    }
}

