/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.dist;

import java.util.concurrent.CompletableFuture;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.auth.ContextGremlinServer;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.slf4j.Logger;

public class HugeGremlinServer {
    private static final Logger LOG = Log.logger(HugeGremlinServer.class);

    public static GremlinServer start(String conf, String graphsDir, EventHub hub) throws Exception {
        Settings settings;
        LOG.info(GremlinServer.getHeader());
        try {
            settings = Settings.read((String)conf);
        }
        catch (Exception e) {
            LOG.error("Can't found the configuration file at '{}' or being parsed properly. [{}]", (Object)conf, (Object)e.getMessage());
            throw e;
        }
        E.checkState((settings.graphs != null ? 1 : 0) != 0, (String)"The GremlinServer's settings.graphs is null", (Object[])new Object[0]);
        settings.graphs.putAll(ConfigUtil.scanGraphsDir((String)graphsDir));
        LOG.info("Configuring Gremlin Server from {}", (Object)conf);
        ContextGremlinServer server = new ContextGremlinServer(settings, hub);
        server.injectTraversalSource();
        ((CompletableFuture)server.start().exceptionally(t -> {
            LOG.error("Gremlin Server was unable to start and will shutdown now: {}", (Object)t.getMessage());
            server.stop().join();
            throw new HugeException("Failed to start Gremlin Server");
        })).join();
        return server;
    }
}

