/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.FSMCallerImpl;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.error.LogEntryCorruptedException;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class IteratorImpl {
    private final FSMCallerImpl fsmCaller;
    private final LogManager logManager;
    private final List<Closure> closures;
    private final long firstClosureIndex;
    private long currentIndex;
    private final long committedIndex;
    private long fsmCommittedIndex;
    private LogEntry currEntry = new LogEntry();
    private final AtomicLong applyingIndex;
    private RaftException error;

    public IteratorImpl(FSMCallerImpl fsmCaller, LogManager logManager, List<Closure> closures, long firstClosureIndex, long lastAppliedIndex, long committedIndex, AtomicLong applyingIndex) {
        this.fsmCaller = fsmCaller;
        this.fsmCommittedIndex = -1L;
        this.logManager = logManager;
        this.closures = closures;
        this.firstClosureIndex = firstClosureIndex;
        this.currentIndex = lastAppliedIndex;
        this.committedIndex = committedIndex;
        this.applyingIndex = applyingIndex;
        this.next();
    }

    public String toString() {
        return "IteratorImpl [fsmCaller=" + this.fsmCaller + ", logManager=" + this.logManager + ", closures=" + this.closures + ", firstClosureIndex=" + this.firstClosureIndex + ", currentIndex=" + this.currentIndex + ", committedIndex=" + this.committedIndex + ", fsmCommittedIndex=" + this.fsmCommittedIndex + ", currEntry=" + this.currEntry + ", applyingIndex=" + this.applyingIndex + ", error=" + this.error + "]";
    }

    public LogEntry entry() {
        return this.currEntry;
    }

    public RaftException getError() {
        return this.error;
    }

    public boolean isGood() {
        return this.currentIndex <= this.committedIndex && !this.hasError();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void next() {
        this.currEntry = null;
        if (this.currentIndex <= this.committedIndex) {
            ++this.currentIndex;
            if (this.currentIndex <= this.committedIndex) {
                try {
                    this.currEntry = this.logManager.getEntry(this.currentIndex);
                    if (this.currEntry == null) {
                        this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_LOG);
                        this.getOrCreateError().getStatus().setError(-1, "Fail to get entry at index=%d while committed_index=%d", this.currentIndex, this.committedIndex);
                    }
                }
                catch (LogEntryCorruptedException e) {
                    this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_LOG);
                    this.getOrCreateError().getStatus().setError(RaftError.EINVAL, e.getMessage(), new Object[0]);
                }
                this.applyingIndex.set(this.currentIndex);
            }
        }
    }

    public long getIndex() {
        return this.currentIndex;
    }

    public Closure done() {
        if (this.currentIndex < this.firstClosureIndex) {
            return null;
        }
        return this.closures.get((int)(this.currentIndex - this.firstClosureIndex));
    }

    protected void runTheRestClosureWithError() {
        for (long i = Math.max(this.currentIndex, this.firstClosureIndex); i <= this.committedIndex; ++i) {
            Closure done = this.closures.get((int)(i - this.firstClosureIndex));
            if (done == null) continue;
            Requires.requireNonNull(this.error, "error");
            Requires.requireNonNull(this.error.getStatus(), "error.status");
            Status status = this.error.getStatus();
            Utils.runClosureInThread(done, status);
        }
    }

    public boolean commit() {
        if (this.isGood() && this.currEntry != null && this.currEntry.getType() == EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            this.fsmCommittedIndex = this.currentIndex;
            this.fsmCaller.setLastApplied(this.currentIndex, this.currEntry.getId().getTerm());
            return true;
        }
        return false;
    }

    public void commitAndSnapshotSync(Closure done) {
        if (this.commit()) {
            this.fsmCaller.getNode().snapshotSync(done);
        } else {
            Utils.runClosure(done, new Status(RaftError.ECANCELED, "Fail to commit, logIndex=" + this.currentIndex + ", committedIndex=" + this.committedIndex, new Object[0]));
        }
    }

    public void setErrorAndRollback(long ntail, Status st) {
        Requires.requireTrue(ntail > 0L, "Invalid ntail=" + ntail);
        this.currentIndex = this.currEntry == null || this.currEntry.getType() != EnumOutter.EntryType.ENTRY_TYPE_DATA ? (this.currentIndex -= ntail) : (this.currentIndex -= ntail - 1L);
        if (this.fsmCommittedIndex >= 0L) {
            this.currentIndex = Math.max(this.currentIndex, this.fsmCommittedIndex + 1L);
        }
        this.currEntry = null;
        this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_STATE_MACHINE);
        this.getOrCreateError().getStatus().setError(RaftError.ESTATEMACHINE, "StateMachine meet critical error when applying one or more tasks since index=%d, %s", this.currentIndex, st != null ? st.toString() : "none");
    }

    private RaftException getOrCreateError() {
        if (this.error == null) {
            this.error = new RaftException();
        }
        return this.error;
    }
}

