/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoResourceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphProvider
implements GraphProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGraphProvider.class);

    public abstract Map<String, Object> getBaseConfiguration(String var1, Class<?> var2, String var3, LoadGraphWith.GraphData var4);

    @Override
    public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, Map<String, Object> configurationOverrides, LoadGraphWith.GraphData loadGraphWith) {
        BaseConfiguration conf = new BaseConfiguration();
        this.getBaseConfiguration(graphName, test, testMethodName, loadGraphWith).entrySet().stream().forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$0((Configuration)conf, arg_0));
        configurationOverrides.entrySet().stream().filter(c -> !((String)c.getKey()).equals("gremlin.graph")).forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$2((Configuration)conf, arg_0));
        return conf;
    }

    @Override
    public void loadGraphData(Graph graph, LoadGraphWith loadGraphWith, Class testClass, String testName) {
        try {
            if (loadGraphWith != null) {
                this.readIntoGraph(graph, loadGraphWith.value().location());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Graph could not be loaded with data for test: " + ioe.getMessage(), ioe);
        }
    }

    protected static void deleteDirectory(File directory) {
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    AbstractGraphProvider.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
        if (directory.exists()) {
            logger.error("unable to delete directory " + directory.getAbsolutePath());
        }
    }

    protected String makeTestDirectory(String graphName, Class<?> test, String testMethodName) {
        return this.getWorkingDirectory() + File.separator + TestHelper.cleanPathSegment((String)this.getClass().getSimpleName()) + File.separator + TestHelper.cleanPathSegment((String)test.getSimpleName()) + File.separator + TestHelper.cleanPathSegment((String)graphName) + File.separator + this.cleanParameters(TestHelper.cleanPathSegment((String)testMethodName));
    }

    protected String cleanParameters(String methodName) {
        int random = (int)(Math.random() * 2.147483647E9);
        return methodName.replaceAll("[0-9, -]+$", String.valueOf(random));
    }

    protected void readIntoGraph(Graph graph, String path) throws IOException {
        String dataFile = TestHelper.generateTempFileFromResource(graph.getClass(), GryoResourceAccess.class, (String)path.substring(path.lastIndexOf(File.separator) + 1), (String)"", (boolean)false).getAbsolutePath();
        graph.traversal().io(dataFile).read().iterate();
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$2(Configuration conf, Map.Entry e) {
        conf.setProperty((String)e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$0(Configuration conf, Map.Entry e) {
        conf.setProperty((String)e.getKey(), e.getValue());
    }
}

