/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.IdUtil;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.serializer.TableSerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.cassandra.CassandraBackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;

public class CassandraSerializer
extends TableSerializer {
    public CassandraSerializer(HugeConfig config) {
        super(config);
    }

    public CassandraBackendEntry newBackendEntry(HugeType type, Id id) {
        return new CassandraBackendEntry(type, id);
    }

    protected TableBackendEntry newBackendEntry(TableBackendEntry.Row row) {
        return new CassandraBackendEntry(row);
    }

    protected TableBackendEntry newBackendEntry(HugeIndex index) {
        CassandraBackendEntry backendEntry = this.newBackendEntry(index.type(), index.id());
        if (index.indexLabel().olap()) {
            backendEntry.olap(true);
        }
        return backendEntry;
    }

    protected CassandraBackendEntry convertEntry(BackendEntry backendEntry) {
        if (!(backendEntry instanceof CassandraBackendEntry)) {
            throw new BackendException("Not supported by CassandraSerializer");
        }
        return (CassandraBackendEntry)backendEntry;
    }

    protected Set<Object> parseIndexElemIds(TableBackendEntry entry) {
        return ImmutableSet.of((Object)entry.column(HugeKeys.ELEMENT_IDS));
    }

    protected Id toId(Number number) {
        return IdGenerator.of((long)number.longValue());
    }

    protected Id[] toIdArray(Object object) {
        assert (object instanceof Collection);
        Collection numbers = (Collection)object;
        Id[] ids = new Id[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ids[i++] = this.toId(number);
        }
        return ids;
    }

    protected Object toLongSet(Collection<Id> ids) {
        Set results = InsertionOrderUtil.newSet();
        for (Id id : ids) {
            results.add(id.asLong());
        }
        return results;
    }

    protected Object toLongList(Collection<Id> ids) {
        ArrayList<Long> results = new ArrayList<Long>(ids.size());
        for (Id id : ids) {
            results.add(id.asLong());
        }
        return results;
    }

    protected void formatProperties(HugeElement element, TableBackendEntry.Row row) {
        if (!element.hasProperties() && !element.removed()) {
            row.column(HugeKeys.PROPERTIES, (Object)ImmutableMap.of());
        } else {
            for (HugeProperty prop : element.getProperties()) {
                this.formatProperty(prop, row);
            }
        }
    }

    protected void parseProperties(HugeElement element, TableBackendEntry.Row row) {
        Map props = (Map)row.column(HugeKeys.PROPERTIES);
        for (Map.Entry prop : props.entrySet()) {
            Id pkeyId = this.toId((Number)prop.getKey());
            this.parseProperty(pkeyId, prop.getValue(), element);
        }
    }

    public BackendEntry writeOlapVertex(HugeVertex vertex) {
        CassandraBackendEntry entry = this.newBackendEntry(HugeType.OLAP, vertex.id());
        entry.column(HugeKeys.ID, this.writeId(vertex.id()));
        Collection properties = vertex.getProperties();
        E.checkArgument((properties.size() == 1 ? 1 : 0) != 0, (String)"Expect only 1 property for olap vertex, but got %s", (Object[])new Object[]{properties.size()});
        HugeProperty property = (HugeProperty)properties.iterator().next();
        PropertyKey pk = property.propertyKey();
        entry.subId(pk.id());
        entry.column(HugeKeys.PROPERTY_VALUE, this.writeProperty(pk, property.value()));
        entry.olap(true);
        return entry;
    }

    protected Object writeProperty(PropertyKey propertyKey, Object value) {
        BytesBuffer buffer = BytesBuffer.allocate((int)64);
        if (propertyKey == null) {
            propertyKey = new PropertyKey(null, IdGenerator.of((long)0L), "fake");
            propertyKey.dataType(DataType.fromClass(value.getClass()));
        }
        buffer.writeProperty(propertyKey, value);
        buffer.forReadWritten();
        return buffer.asByteBuffer();
    }

    protected <T> T readProperty(PropertyKey pkey, Object value) {
        BytesBuffer buffer = BytesBuffer.wrap((ByteBuffer)((ByteBuffer)value));
        return (T)buffer.readProperty(pkey);
    }

    protected Object writeId(Id id) {
        return IdUtil.writeBinString((Id)id);
    }

    protected Id readId(Object id) {
        return IdUtil.readBinString((Object)id);
    }

    protected void writeUserdata(SchemaElement schema, TableBackendEntry entry) {
        assert (entry instanceof CassandraBackendEntry);
        for (Map.Entry e : schema.userdata().entrySet()) {
            entry.column(HugeKeys.USER_DATA, e.getKey(), (Object)JsonUtil.toJson(e.getValue()));
        }
    }

    protected void readUserdata(SchemaElement schema, TableBackendEntry entry) {
        assert (entry instanceof CassandraBackendEntry);
        Map userdata = (Map)entry.column(HugeKeys.USER_DATA);
        for (Map.Entry e : userdata.entrySet()) {
            String key = (String)e.getKey();
            Object value = JsonUtil.fromJson((String)((String)e.getValue()), Object.class);
            schema.userdata(key, value);
        }
    }
}

