/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SelectStep<S, E>
extends MapStep<S, Map<String, E>>
implements Scoping,
TraversalParent,
PathProcessor,
ByModulating {
    private TraversalRing<Object, E> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private final Pop pop;
    private final List<String> selectKeys;
    private final Set<String> selectKeysSet;
    private Set<String> keepLabels;

    public SelectStep(Traversal.Admin traversal, Pop pop, String ... selectKeys) {
        super(traversal);
        this.pop = pop;
        this.selectKeys = Arrays.asList(selectKeys);
        this.selectKeysSet = Collections.unmodifiableSet(new HashSet<String>(this.selectKeys));
        if (this.selectKeys.size() < 2) {
            throw new IllegalArgumentException("At least two select keys must be provided: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Traverser.Admin<Map<String, E>> processNextStart() throws NoSuchElementException {
        Object traverser = this.starts.next();
        LinkedHashMap<String, E> bindings = new LinkedHashMap<String, E>(this.selectKeys.size(), 1.0f);
        try {
            for (String selectKey : this.selectKeys) {
                Object end = this.getScopeValue(this.pop, selectKey, (Traverser.Admin<?>)traverser);
                bindings.put(selectKey, TraversalUtil.applyNullable(end, this.traversalRing.next()));
            }
        }
        catch (Scoping.KeyNotFoundException nfe) {
            EmptyTraverser<Map<String, E>> emptyTraverser = EmptyTraverser.instance();
            return emptyTraverser;
        }
        finally {
            this.traversalRing.reset();
        }
        return PathProcessor.processTraverserPathLabels(traverser.split(bindings, this), this.keepLabels);
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.pop, this.selectKeys, this.traversalRing});
    }

    @Override
    public SelectStep<S, E> clone() {
        SelectStep clone = (SelectStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.traversalRing.hashCode() ^ this.selectKeys.hashCode();
        if (null != this.pop) {
            result ^= this.pop.hashCode();
        }
        return result;
    }

    public List<Traversal.Admin<Object, E>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        this.traversalRing.replaceTraversal(oldTraversal, newTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.selectKeysSet;
    }

    public Map<String, Traversal.Admin<Object, E>> getByTraversals() {
        HashMap<String, Traversal.Admin<Object, E>> map = new HashMap<String, Traversal.Admin<Object, E>>();
        this.traversalRing.reset();
        for (String as : this.selectKeys) {
            map.put(as, this.traversalRing.next());
        }
        return map;
    }

    public Pop getPop() {
        return this.pop;
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }
}

