/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.io.File;
import org.apache.hugegraph.backend.store.AbstractBackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBOptions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBStore;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.ConfigUtil;

public class RocksDBStoreProvider
extends AbstractBackendStoreProvider {
    protected String database() {
        return this.graph().toLowerCase();
    }

    protected BackendStore newSchemaStore(HugeConfig config, String store) {
        return new RocksDBStore.RocksDBSchemaStore((BackendStoreProvider)this, this.database(), store);
    }

    protected BackendStore newGraphStore(HugeConfig config, String store) {
        return new RocksDBStore.RocksDBGraphStore((BackendStoreProvider)this, this.database(), store);
    }

    public void onCloneConfig(HugeConfig config, String newGraph) {
        super.onCloneConfig(config, newGraph);
        String suffix = "_" + newGraph;
        String dataPath = (String)config.get(RocksDBOptions.DATA_PATH);
        config.setProperty(RocksDBOptions.DATA_PATH.name(), (Object)(dataPath + suffix));
        String walPath = (String)config.get(RocksDBOptions.WAL_PATH);
        config.setProperty(RocksDBOptions.WAL_PATH.name(), (Object)(walPath + suffix));
    }

    public void onDeleteConfig(HugeConfig config) {
        super.onDeleteConfig(config);
        String dataPath = (String)config.get(RocksDBOptions.DATA_PATH);
        String walPath = (String)config.get(RocksDBOptions.WAL_PATH);
        ConfigUtil.deleteFile((File)new File(dataPath));
        ConfigUtil.deleteFile((File)new File(walPath));
    }

    protected BackendStore newSystemStore(HugeConfig config, String store) {
        return new RocksDBStore.RocksDBSystemStore((BackendStoreProvider)this, this.database(), store);
    }

    public String type() {
        return "rocksdb";
    }

    public String driverVersion() {
        return "1.11";
    }
}

