/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api;

import com.codahale.metrics.Meter;
import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.MediaType;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class API {
    public static final String CHARSET = "UTF-8";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_WITH_CHARSET = "application/json;charset=UTF-8";
    public static final String APPLICATION_TEXT_WITH_CHARSET = "text/plain;charset=UTF-8";
    public static final String JSON = MediaType.APPLICATION_JSON_TYPE.getSubtype();
    public static final String ACTION_APPEND = "append";
    public static final String ACTION_ELIMINATE = "eliminate";
    public static final String ACTION_CLEAR = "clear";
    protected static final Logger LOG = Log.logger(API.class);
    private static final Meter SUCCEED_METER = MetricsUtil.registerMeter(API.class, "commit-succeed");
    private static final Meter ILLEGAL_ARG_ERROR_METER = MetricsUtil.registerMeter(API.class, "illegal-arg");
    private static final Meter EXPECTED_ERROR_METER = MetricsUtil.registerMeter(API.class, "expected-error");
    private static final Meter UNKNOWN_ERROR_METER = MetricsUtil.registerMeter(API.class, "unknown-error");

    public static HugeGraph graph(GraphManager manager, String graph) {
        HugeGraph g = manager.graph(graph);
        if (g == null) {
            throw new NotFoundException(String.format("Graph '%s' does not exist", graph));
        }
        return g;
    }

    public static HugeGraph graph4admin(GraphManager manager, String graph) {
        return API.graph(manager, graph).hugegraph();
    }

    public static <R> R commit(HugeGraph g, Callable<R> callable) {
        Consumer<Throwable> rollback = error -> {
            if (error != null) {
                LOG.error("Failed to commit", error);
            }
            try {
                g.tx().rollback();
            }
            catch (Throwable e) {
                LOG.error("Failed to rollback", e);
            }
        };
        try {
            R result = callable.call();
            g.tx().commit();
            SUCCEED_METER.mark();
            return result;
        }
        catch (ForbiddenException | IllegalArgumentException | NotFoundException e) {
            ILLEGAL_ARG_ERROR_METER.mark();
            rollback.accept(null);
            throw e;
        }
        catch (RuntimeException e) {
            EXPECTED_ERROR_METER.mark();
            rollback.accept(e);
            throw e;
        }
        catch (Throwable e) {
            UNKNOWN_ERROR_METER.mark();
            rollback.accept(e);
            throw new HugeException("Failed to commit", e);
        }
    }

    public static void commit(HugeGraph g, Runnable runnable) {
        API.commit(g, () -> {
            runnable.run();
            return null;
        });
    }

    public static Object[] properties(Map<String, Object> properties) {
        Object[] list = new Object[properties.size() * 2];
        int i = 0;
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            list[i++] = prop.getKey();
            list[i++] = prop.getValue();
        }
        return list;
    }

    protected static void checkCreatingBody(Checkable body) {
        E.checkArgumentNotNull((Object)body, (String)"The request body can't be empty", (Object[])new Object[0]);
        body.checkCreate(false);
    }

    protected static void checkUpdatingBody(Checkable body) {
        E.checkArgumentNotNull((Object)body, (String)"The request body can't be empty", (Object[])new Object[0]);
        body.checkUpdate();
    }

    protected static void checkCreatingBody(Collection<? extends Checkable> bodies) {
        E.checkArgumentNotNull(bodies, (String)"The request body can't be empty", (Object[])new Object[0]);
        for (Checkable checkable : bodies) {
            E.checkArgument((checkable != null ? 1 : 0) != 0, (String)"The batch body can't contain null record", (Object[])new Object[0]);
            checkable.checkCreate(true);
        }
    }

    protected static void checkUpdatingBody(Collection<? extends Checkable> bodies) {
        E.checkArgumentNotNull(bodies, (String)"The request body can't be empty", (Object[])new Object[0]);
        for (Checkable checkable : bodies) {
            E.checkArgumentNotNull((Object)checkable, (String)"The batch body can't contain null record", (Object[])new Object[0]);
            checkable.checkUpdate();
        }
    }

    protected static Map<String, Object> parseProperties(String properties) {
        if (properties == null || properties.isEmpty()) {
            return ImmutableMap.of();
        }
        Map props = null;
        try {
            props = (Map)JsonUtil.fromJson((String)properties, Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        E.checkArgument((props != null ? 1 : 0) != 0, (String)"Invalid request with properties: %s", (Object[])new Object[]{properties});
        return props;
    }

    public static boolean checkAndParseAction(String action) {
        E.checkArgumentNotNull((Object)action, (String)"The action param can't be empty", (Object[])new Object[0]);
        if (action.equals(ACTION_APPEND)) {
            return true;
        }
        if (action.equals(ACTION_ELIMINATE)) {
            return false;
        }
        throw new NotSupportedException(String.format("Not support action '%s'", action));
    }

    public static class ApiMeasurer {
        public static final String EDGE_ITER = "edge_iterations";
        public static final String VERTICE_ITER = "vertice_iterations";
        public static final String COST = "cost(ns)";
        private final long timeStart = System.nanoTime();
        private final Map<String, Object> measures = InsertionOrderUtil.newMap();

        public Map<String, Object> measures() {
            this.measures.put(COST, System.nanoTime() - this.timeStart);
            return this.measures;
        }

        public void put(String key, String value) {
            this.measures.put(key, value);
        }

        public void put(String key, long value) {
            this.measures.put(key, value);
        }

        public void put(String key, int value) {
            this.measures.put(key, value);
        }

        protected void addCount(String key, long value) {
            Object current = this.measures.get(key);
            if (current == null) {
                this.measures.put(key, new MutableLong(value));
            } else if (current instanceof MutableLong) {
                ((MutableLong)this.measures.computeIfAbsent(key, MutableLong::new)).add(value);
            } else if (current instanceof Long) {
                Long currentLong = (Long)current;
                this.measures.put(key, new MutableLong(currentLong + value));
            } else {
                throw new NotSupportedException("addCount() method's 'value' datatype must be Long or MutableLong");
            }
        }

        public void addIterCount(long verticeIters, long edgeIters) {
            this.addCount(EDGE_ITER, edgeIters);
            this.addCount(VERTICE_ITER, verticeIters);
        }
    }
}

