/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.cypher;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.hugegraph.api.cypher.CypherClient;
import org.apache.hugegraph.util.E;

@ThreadSafe
public final class CypherManager {
    private final String configurationFile;
    private YAMLConfiguration configuration;

    public static CypherManager configOf(String configurationFile) {
        E.checkArgument((configurationFile != null && !configurationFile.isEmpty() ? 1 : 0) != 0, (String)"The configurationFile parameter can't be null or empty", (Object[])new Object[0]);
        return new CypherManager(configurationFile);
    }

    private CypherManager(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public CypherClient getClient(String userName, String password) {
        E.checkArgument((userName != null && !userName.isEmpty() ? 1 : 0) != 0, (String)"The userName parameter can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((password != null && !password.isEmpty() ? 1 : 0) != 0, (String)"The password parameter can't be null or empty", (Object[])new Object[0]);
        return new CypherClient(userName, password, this::cloneConfig);
    }

    public CypherClient getClient(String token) {
        E.checkArgument((token != null && !token.isEmpty() ? 1 : 0) != 0, (String)"The token parameter can't be null or empty", (Object[])new Object[0]);
        return new CypherClient(token, this::cloneConfig);
    }

    private Configuration cloneConfig() {
        if (this.configuration == null) {
            this.configuration = CypherManager.loadYaml(this.configurationFile);
        }
        return (Configuration)this.configuration.clone();
    }

    private static YAMLConfiguration loadYaml(String configurationFile) {
        YAMLConfiguration yaml;
        File yamlFile = CypherManager.getConfigFile(configurationFile);
        try {
            FileReader reader = new FileReader(yamlFile);
            yaml = new YAMLConfiguration();
            yaml.read((Reader)reader);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to load configuration file, the file at '%s'.", configurationFile), e);
        }
        return yaml;
    }

    private static File getConfigFile(String configurationFile) {
        File systemFile = new File(configurationFile);
        if (!systemFile.exists()) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            URL resource = currentClassLoader.getResource(configurationFile);
            assert (resource != null);
            File resourceFile = new File(resource.getFile());
            if (!resourceFile.exists()) {
                throw new IllegalArgumentException(String.format("Configuration file at '%s' does not exist", configurationFile));
            }
            return resourceFile;
        }
        return systemFile;
    }
}

