/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Provider
@Singleton
public class AccessLogFilter
implements ContainerResponseFilter {
    private static final Logger LOG = Log.logger(AccessLogFilter.class);
    private static final String DELIMITER = "/";
    private static final String GRAPHS = "graphs";
    private static final String GREMLIN = "gremlin";
    private static final String CYPHER = "cypher";
    @Context
    private jakarta.inject.Provider<HugeConfig> configProvider;
    @Context
    private jakarta.inject.Provider<GraphManager> managerProvider;

    public static boolean needRecordLog(ContainerRequestContext context) {
        String path = context.getUriInfo().getPath();
        if (path.startsWith(GRAPHS) && ("GET".equals(context.getMethod()) || path.endsWith(CYPHER))) {
            return true;
        }
        return path.endsWith(GREMLIN);
    }

    private String join(String path1, String path2) {
        return String.join((CharSequence)DELIMITER, path1, path2);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        GraphManager manager;
        URI uri = requestContext.getUriInfo().getRequestUri();
        String path = uri.getRawPath();
        String method = requestContext.getMethod();
        String metricsName = this.join(path, method);
        MetricsUtil.registerCounter(this.join(metricsName, "TOTAL_COUNTER")).inc();
        if (this.statusOk(responseContext.getStatus())) {
            MetricsUtil.registerCounter(this.join(metricsName, "SUCCESS_COUNTER")).inc();
        } else {
            MetricsUtil.registerCounter(this.join(metricsName, "FAILED_COUNTER")).inc();
        }
        Object requestTime = requestContext.getProperty("request_time");
        if (requestTime != null) {
            long now = System.currentTimeMillis();
            long start = (Long)requestTime;
            long executeTime = now - start;
            MetricsUtil.registerHistogram(this.join(metricsName, "RESPONSE_TIME_HISTOGRAM")).update(executeTime);
            HugeConfig config = (HugeConfig)this.configProvider.get();
            long timeThreshold = (Long)config.get(ServerOptions.SLOW_QUERY_LOG_TIME_THRESHOLD);
            if (timeThreshold > 0L && executeTime > timeThreshold && AccessLogFilter.needRecordLog(requestContext)) {
                LOG.info("[Slow Query] execTime={}ms, body={}, method={}, path={}, query={}", new Object[]{executeTime, null, method, path, uri.getQuery()});
            }
        }
        if ((manager = (GraphManager)this.managerProvider.get()).requireAuthentication()) {
            manager.unauthorize(requestContext.getSecurityContext());
        }
    }

    private boolean statusOk(int status) {
        return status >= 200 && status < 300;
    }
}

