/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.gremlin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.gremlin.GremlinClient;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.exception.HugeGremlinException;

public class GremlinQueryAPI
extends API {
    private static final Set<String> FORBIDDEN_REQUEST_EXCEPTIONS = ImmutableSet.of((Object)"java.lang.SecurityException", (Object)"jakarta.ws.rs.ForbiddenException");
    private static final Set<String> BAD_REQUEST_EXCEPTIONS = ImmutableSet.of((Object)"java.lang.IllegalArgumentException", (Object)"java.util.concurrent.TimeoutException", (Object)"groovy.lang.", (Object)"org.codehaus.", (Object)"org.apache.hugegraph.");
    @Context
    private Provider<HugeConfig> configProvider;
    private GremlinClient client;

    public GremlinClient client() {
        if (this.client != null) {
            return this.client;
        }
        HugeConfig config = (HugeConfig)this.configProvider.get();
        String url = (String)config.get(ServerOptions.GREMLIN_SERVER_URL);
        int timeout = (Integer)config.get(ServerOptions.GREMLIN_SERVER_TIMEOUT) * 1000;
        int maxRoutes = (Integer)config.get(ServerOptions.GREMLIN_SERVER_MAX_ROUTE);
        this.client = new GremlinClient(url, timeout, maxRoutes, maxRoutes);
        return this.client;
    }

    protected static Response transformResponseIfNeeded(Response response) {
        Response.StatusType status;
        MediaType mediaType = response.getMediaType();
        if (mediaType != null) {
            assert (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType));
            response.getHeaders().putSingle((Object)"Content-Type", (Object)mediaType.withCharset("UTF-8"));
        }
        if ((status = response.getStatusInfo()).getStatusCode() < 400) {
            return response;
        }
        if (mediaType == null || !JSON.equals(mediaType.getSubtype())) {
            String message = (String)response.readEntity(String.class);
            throw new HugeGremlinException(status.getStatusCode(), (Map)ImmutableMap.of((Object)"message", (Object)message));
        }
        Map map = (Map)response.readEntity(Map.class);
        String exClassName = (String)map.get("Exception-Class");
        if (FORBIDDEN_REQUEST_EXCEPTIONS.contains(exClassName)) {
            status = Response.Status.FORBIDDEN;
        } else if (GremlinQueryAPI.matchBadRequestException(exClassName)) {
            status = Response.Status.BAD_REQUEST;
        }
        throw new HugeGremlinException(status.getStatusCode(), map);
    }

    private static boolean matchBadRequestException(String exClass) {
        if (exClass == null) {
            return false;
        }
        if (BAD_REQUEST_EXCEPTIONS.contains(exClass)) {
            return true;
        }
        return BAD_REQUEST_EXCEPTIONS.stream().anyMatch(exClass::startsWith);
    }
}

