/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.job;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.RedirectFilter;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/jobs/rebuild")
@Singleton
@Tag(name="RebuildAPI")
public class RebuildAPI
extends API {
    private static final Logger LOG = Log.logger(RebuildAPI.class);

    @PUT
    @Timed
    @Path(value="vertexlabels/{name}")
    @StatusFilter.Status(value=202)
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_write"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> vertexLabelRebuild(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] rebuild vertex label: {}", (Object)graph, (Object)name);
        HugeGraph g = RebuildAPI.graph(manager, graph);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().vertexLabel(name).rebuildIndex());
    }

    @PUT
    @Timed
    @Path(value="edgelabels/{name}")
    @StatusFilter.Status(value=202)
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_write"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> edgeLabelRebuild(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] rebuild edge label: {}", (Object)graph, (Object)name);
        HugeGraph g = RebuildAPI.graph(manager, graph);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().edgeLabel(name).rebuildIndex());
    }

    @PUT
    @Timed
    @Path(value="indexlabels/{name}")
    @StatusFilter.Status(value=202)
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_write"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> indexLabelRebuild(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] rebuild index label: {}", (Object)graph, (Object)name);
        HugeGraph g = RebuildAPI.graph(manager, graph);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().indexLabel(name).rebuild());
    }
}

