/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.metrics.MetricsKeys;
import org.apache.hugegraph.metrics.MetricsModule;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.metrics.ServerReporter;
import org.apache.hugegraph.metrics.SystemMetrics;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.version.ApiVersion;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.slf4j.Logger;

@Singleton
@Path(value="metrics")
@Tag(name="MetricsAPI")
public class MetricsAPI
extends API {
    private static final Logger LOG = Log.logger(MetricsAPI.class);
    private static final String JSON_STR = "json";
    private final SystemMetrics systemMetrics = new SystemMetrics();

    @GET
    @Timed
    @Path(value="system")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the system metrics")
    public String system() {
        return JsonUtil.toJson(this.systemMetrics.metrics());
    }

    @GET
    @Timed
    @Path(value="backend")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the backend metrics")
    public String backend(@Context GraphManager manager) {
        Map results = InsertionOrderUtil.newMap();
        for (String graph : manager.graphs()) {
            HugeGraph g = manager.graph(graph);
            Map metrics = InsertionOrderUtil.newMap();
            metrics.put("backend", g.backend());
            try {
                metrics.putAll((Map)g.metadata(null, "metrics", new Object[0]));
            }
            catch (Throwable e) {
                metrics.put("exception", e.toString());
                LOG.debug("Failed to get backend metrics", e);
            }
            results.put(graph, metrics);
        }
        return JsonUtil.toJson((Object)results);
    }

    @GET
    @Timed
    @Path(value="gauges")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the gauges metrics")
    public String gauges() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.gauges());
    }

    @GET
    @Timed
    @Path(value="counters")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the counters metrics")
    public String counters() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.counters());
    }

    @GET
    @Timed
    @Path(value="histograms")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the histograms metrics")
    public String histograms() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.histograms());
    }

    @GET
    @Timed
    @Path(value="meters")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the meters metrics")
    public String meters() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.meters());
    }

    @GET
    @Timed
    @Path(value="timers")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get the timers metrics")
    public String timers() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.timers());
    }

    @GET
    @Timed
    @Produces(value={"text/plain;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get all base metrics")
    public String all(@Context GraphManager manager, @QueryParam(value="type") String type) {
        if (type != null && type.equals(JSON_STR)) {
            return this.baseMetricAll();
        }
        return this.baseMetricPrometheusAll();
    }

    @GET
    @Path(value="statistics")
    @Timed
    @Produces(value={"text/plain;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    @Operation(summary="get all statistics metrics")
    public String statistics(@QueryParam(value="type") String type) {
        Map<String, Map<String, Object>> metricMap = this.statistics();
        if (type != null && type.equals(JSON_STR)) {
            return JsonUtil.toJson(metricMap);
        }
        return this.statisticsProm(metricMap);
    }

    public String baseMetricAll() {
        ServerReporter reporter = ServerReporter.instance();
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        result.put("gauges", reporter.gauges());
        result.put("counters", reporter.counters());
        result.put("histograms", reporter.histograms());
        result.put("meters", reporter.meters());
        result.put("timers", reporter.timers());
        return JsonUtil.toJson(result);
    }

    private String baseMetricPrometheusAll() {
        StringBuilder promMetric = new StringBuilder();
        ServerReporter reporter = ServerReporter.instance();
        String helpName = "hugegraph_info";
        promMetric.append("# HELP ").append(helpName).append("\n");
        promMetric.append("# TYPE ").append(helpName).append(" untyped\n");
        promMetric.append(helpName).append("{version=\"").append(ApiVersion.VERSION.toString()).append("\",}").append(" 1.0\n");
        for (String key : reporter.gauges().keySet()) {
            Gauge<?> gauge = reporter.gauges().get(key);
            if (gauge == null) continue;
            helpName = MetricsUtil.replaceDotDashInKey(key);
            promMetric.append("# HELP ").append(helpName).append("\n");
            promMetric.append("# TYPE ").append(helpName).append(" gauge\n");
            promMetric.append(helpName).append(" " + gauge.getValue() + "\n");
        }
        for (String histogramkey : reporter.histograms().keySet()) {
            Histogram histogram = reporter.histograms().get(histogramkey);
            if (histogram == null) continue;
            helpName = MetricsUtil.replaceDotDashInKey(histogramkey);
            promMetric.append("# HELP ").append(helpName).append("\n");
            promMetric.append("# TYPE ").append(helpName).append(" histogram\n");
            promMetric.append(helpName).append("{name=\"count\",} ").append(histogram.getCount() + "\n");
            promMetric.append(MetricsUtil.exportSnapshot(helpName, histogram.getSnapshot()));
        }
        for (String meterkey : reporter.meters().keySet()) {
            Meter metric = reporter.meters().get(meterkey);
            if (metric == null) continue;
            helpName = MetricsUtil.replaceDotDashInKey(meterkey);
            promMetric.append("# HELP ").append(helpName).append("\n");
            promMetric.append("# TYPE ").append(helpName).append(" histogram\n");
            promMetric.append(helpName).append("{name=\"count\",} ").append(metric.getCount() + "\n");
            promMetric.append(helpName).append("{name=\"mean_rate\",} ").append(metric.getMeanRate() + "\n");
            promMetric.append(helpName).append("{name=\"m1_rate\",} ").append(metric.getOneMinuteRate() + "\n");
            promMetric.append(helpName).append("{name=\"m5_rate\",} ").append(metric.getFiveMinuteRate() + "\n");
            promMetric.append(helpName).append("{name=\"m15_rate\",} ").append(metric.getFifteenMinuteRate() + "\n");
        }
        for (String timerkey : reporter.timers().keySet()) {
            Timer timer = reporter.timers().get(timerkey);
            if (timer == null) continue;
            helpName = MetricsUtil.replaceDotDashInKey(timerkey);
            promMetric.append("# HELP ").append(helpName).append("\n");
            promMetric.append("# TYPE ").append(helpName).append(" histogram\n");
            promMetric.append(helpName).append("{name=\"count\",} ").append(timer.getCount() + "\n");
            promMetric.append(helpName).append("{name=\"m1_rate\",} ").append(timer.getOneMinuteRate() + "\n");
            promMetric.append(helpName).append("{name=\"m5_rate\",} ").append(timer.getFiveMinuteRate() + "\n");
            promMetric.append(helpName).append("{name=\"m15_rate\",} ").append(timer.getFifteenMinuteRate() + "\n");
            promMetric.append(MetricsUtil.exportSnapshot(helpName, timer.getSnapshot()));
        }
        MetricsUtil.writePrometheusFormat(promMetric, MetricManager.INSTANCE.getRegistry());
        return promMetric.toString();
    }

    private Map<String, Map<String, Object>> statistics() {
        HashMap<String, Map<String, Object>> metricsMap = new HashMap<String, Map<String, Object>>();
        ServerReporter reporter = ServerReporter.instance();
        for (Map.Entry<String, Histogram> entry : reporter.histograms().entrySet()) {
            String entryKey = entry.getKey();
            String[] split = entryKey.split("/");
            String lastWord = split[split.length - 1];
            if (!lastWord.equals("RESPONSE_TIME_HISTOGRAM")) continue;
            String metricsName = entryKey.substring(0, entryKey.length() - lastWord.length() - 1);
            Counter totalCounter = reporter.counters().get(this.joinWithSlash(metricsName, "TOTAL_COUNTER"));
            Counter failedCounter = reporter.counters().get(this.joinWithSlash(metricsName, "FAILED_COUNTER"));
            Counter successCounter = reporter.counters().get(this.joinWithSlash(metricsName, "SUCCESS_COUNTER"));
            Histogram histogram = entry.getValue();
            HashMap<String, Number> entryMetricsMap = new HashMap<String, Number>();
            entryMetricsMap.put(MetricsKeys.MAX_RESPONSE_TIME.name(), histogram.getSnapshot().getMax());
            entryMetricsMap.put(MetricsKeys.MEAN_RESPONSE_TIME.name(), histogram.getSnapshot().getMean());
            entryMetricsMap.put(MetricsKeys.TOTAL_REQUEST.name(), totalCounter.getCount());
            if (failedCounter == null) {
                entryMetricsMap.put(MetricsKeys.FAILED_REQUEST.name(), 0);
            } else {
                entryMetricsMap.put(MetricsKeys.FAILED_REQUEST.name(), failedCounter.getCount());
            }
            if (successCounter == null) {
                entryMetricsMap.put(MetricsKeys.SUCCESS_REQUEST.name(), 0);
            } else {
                entryMetricsMap.put(MetricsKeys.SUCCESS_REQUEST.name(), successCounter.getCount());
            }
            metricsMap.put(metricsName, entryMetricsMap);
        }
        return metricsMap;
    }

    private String statisticsProm(Map<String, Map<String, Object>> metricMap) {
        StringBuilder promMetric = new StringBuilder();
        promMetric.append("# HELP ").append("hugegraph_info").append("\n");
        promMetric.append("# TYPE ").append("hugegraph_info").append(" untyped\n");
        promMetric.append("hugegraph_info").append("{version=\"").append(ApiVersion.VERSION.toString()).append("\",}").append(" 1.0\n");
        for (String methodKey : metricMap.keySet()) {
            String metricName = MetricsUtil.replaceSlashInKey(methodKey);
            promMetric.append("# HELP ").append(metricName).append("\n");
            promMetric.append("# TYPE ").append(metricName).append(" gauge\n");
            Map<String, Object> itemMetricMap = metricMap.get(methodKey);
            for (String labelName : itemMetricMap.keySet()) {
                promMetric.append(metricName).append("{name=").append(labelName).append(",} ").append(itemMetricMap.get(labelName)).append("\n");
            }
        }
        return promMetric.toString();
    }

    private String joinWithSlash(String path1, String path2) {
        return String.join((CharSequence)"/", path1, path2);
    }

    static {
        JsonUtil.registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
    }
}

