/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.PredictionTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;

@Path(value="graphs/{graph}/traversers/resourceallocation")
@Singleton
@Tag(name="ResourceAllocationAPI")
public class ResourceAllocationAPI
extends API {
    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="vertex") String current, @QueryParam(value="other") String other, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="limit") @DefaultValue(value="10000000") int limit) {
        LOG.debug("Graph [{}] get resource allocation between '{}' and '{}' with direction {}, edge label {}, max degree '{}' and limit '{}'", new Object[]{graph, current, other, direction, edgeLabel, maxDegree, limit});
        Id sourceId = VertexAPI.checkAndParseVertexId(current);
        Id targetId = VertexAPI.checkAndParseVertexId(other);
        E.checkArgument((!current.equals(other) ? 1 : 0) != 0, (String)"The source and target vertex id can't be same", (Object[])new Object[0]);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = ResourceAllocationAPI.graph(manager, graph);
        try (PredictionTraverser traverser = new PredictionTraverser(g);){
            double score = traverser.resourceAllocation(sourceId, targetId, dir, edgeLabel, maxDegree, limit);
            String string = JsonUtil.toJson((Object)ImmutableMap.of((Object)"resource_allocation", (Object)score));
            return string;
        }
    }
}

