/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.opencypher;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.StatementOption;
import org.opencypher.gremlin.translation.ir.TranslationWriter;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.traversal.ParameterNormalizer;
import org.opencypher.gremlin.traversal.ProcedureContext;
import org.opencypher.gremlin.traversal.ReturnNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;

public class CypherOpProcessor
extends AbstractEvalOpProcessor {
    private static final String DEFAULT_TRANSLATOR_DEFINITION = "gremlin+cfog_server_extensions+inline_parameters";
    private static final Logger logger = LoggerFactory.getLogger(CypherOpProcessor.class);

    public CypherOpProcessor() {
        super(true);
    }

    public String getName() {
        return "cypher";
    }

    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalCypher;
    }

    public Optional<ThrowingConsumer<Context>> selectOther(Context ctx) {
        return Optional.empty();
    }

    private void evalCypher(Context context) throws OpProcessorException {
        Map args = context.getRequestMessage().getArgs();
        String cypher = (String)args.get("gremlin");
        logger.trace("Cypher: {}", (Object)cypher.replaceAll("\n", " "));
        GraphTraversalSource gts = this.traversal(context);
        DefaultGraphTraversal g = new DefaultGraphTraversal(gts.clone());
        Map parameters = ParameterNormalizer.normalize(this.getParameters(args));
        ProcedureContext procedureContext = ProcedureContext.global();
        CypherAst ast = CypherAst.parse((String)cypher, (Map)parameters, (Map)procedureContext.getSignatures());
        String translatorDefinition = this.getTranslatorDefinition(context);
        Translator strTranslator = Translator.builder().gremlinGroovy().build(translatorDefinition);
        Translator traversalTranslator = Translator.builder().traversal((GraphTraversal)g).build(translatorDefinition);
        Seq ir = ast.translate(strTranslator.flavor(), (Collection)strTranslator.features(), procedureContext);
        String gremlin = (String)TranslationWriter.write((Seq)ir, (Translator)strTranslator, (Map)parameters);
        logger.trace("Gremlin: {}", (Object)gremlin);
        if (ast.getOptions().contains(StatementOption.EXPLAIN)) {
            this.explainQuery(context, ast, gremlin);
            return;
        }
        GraphTraversal traversal = (GraphTraversal)TranslationWriter.write((Seq)ir, (Translator)traversalTranslator, (Map)parameters);
        ReturnNormalizer returnNormalizer = ReturnNormalizer.create((Map)ast.getReturnTypes());
        Iterator normalizedTraversal = returnNormalizer.normalize((Iterator)traversal);
        this.inTransaction(gts, () -> this.handleIterator(context, normalizedTraversal));
    }

    private void inTransaction(GraphTraversalSource gts, Runnable runnable) {
        block3: {
            Graph graph = gts.getGraph();
            boolean supportsTransactions = graph.features().graph().supportsTransactions();
            if (!supportsTransactions) {
                runnable.run();
                return;
            }
            try {
                graph.tx().open();
                runnable.run();
                graph.tx().commit();
            }
            catch (Exception e) {
                if (!graph.tx().isOpen()) break block3;
                graph.tx().rollback();
            }
        }
    }

    private GraphTraversalSource traversal(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        GraphManager graphManager = context.getGraphManager();
        Optional aliasesOptional = msg.optionalArgs("aliases");
        String gAlias = aliasesOptional.map(alias -> (String)alias.get("g")).orElse(null);
        if (gAlias == null) {
            return graphManager.getGraphNames().stream().sorted().findFirst().map(arg_0 -> ((GraphManager)graphManager).getGraph(arg_0)).map(Graph::traversal).orElseThrow(() -> this.opProcessorException(msg, "No graphs found on the server"));
        }
        Graph graph = graphManager.getGraph(gAlias);
        if (graph != null) {
            return graph.traversal();
        }
        TraversalSource traversalSource = graphManager.getTraversalSource(gAlias);
        if (traversalSource instanceof GraphTraversalSource) {
            return (GraphTraversalSource)traversalSource;
        }
        throw this.opProcessorException(msg, "Traversable alias '" + gAlias + "' not found");
    }

    private OpProcessorException opProcessorException(RequestMessage msg, String errorMessage) {
        return new OpProcessorException(errorMessage, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(errorMessage).create());
    }

    protected void handleIterator(Context context, Iterator traversal) {
        RequestMessage msg = context.getRequestMessage();
        long timeout = msg.getArgs().containsKey("evaluationTimeout") ? ((Number)msg.getArgs().get("evaluationTimeout")).longValue() : context.getSettings().evaluationTimeout;
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            try {
                super.handleIterator(context, traversal);
            }
            catch (Exception ex) {
                String errorMessage = this.getErrorMessage(msg, ex);
                logger.error("Error during traversal iteration", (Throwable)ex);
                ChannelHandlerContext ctx = context.getChannelHandlerContext();
                ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(errorMessage).statusAttributeException((Throwable)ex).create());
            }
            return null;
        });
        Future<?> executionFuture = context.getGremlinExecutor().getExecutorService().submit(evalFuture);
        if (timeout > 0L) {
            context.getScheduledExecutorService().schedule(() -> executionFuture.cancel(true), timeout, TimeUnit.MILLISECONDS);
        }
    }

    private String getErrorMessage(RequestMessage msg, Exception ex) {
        if (ex instanceof InterruptedException || ex instanceof TraversalInterruptedException) {
            return String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to scriptEvaluationTimeout", msg);
        }
        return ex.getMessage();
    }

    private void explainQuery(Context context, CypherAst ast, String gremlin) {
        LinkedHashMap<String, String> explanation = new LinkedHashMap<String, String>();
        explanation.put("translation", gremlin);
        explanation.put("options", ast.getOptions().toString());
        ResponseMessage explainMsg = ResponseMessage.build((RequestMessage)context.getRequestMessage()).code(ResponseStatusCode.SUCCESS).statusMessage("OK").result(Collections.singletonList(explanation)).create();
        ChannelHandlerContext ctx = context.getChannelHandlerContext();
        ctx.writeAndFlush((Object)explainMsg);
    }

    public void close() {
    }

    private Map<String, Object> getParameters(Map<String, Object> args) {
        if (args.containsKey("bindings")) {
            return (Map)args.get("bindings");
        }
        return new HashMap<String, Object>();
    }

    private String getTranslatorDefinition(Context context) {
        Map config = context.getSettings().optionalProcessor(CypherOpProcessor.class).map(p -> p.config).orElse(Collections.emptyMap());
        HashSet properties = new HashSet(config.keySet());
        properties.remove("translatorDefinition");
        properties.remove("translatorFeatures");
        if (!properties.isEmpty()) {
            throw new IllegalStateException("Unknown configuration parameters found for CypherOpProcessor: " + properties);
        }
        return config.getOrDefault("translatorDefinition", DEFAULT_TRANSLATOR_DEFINITION) + "+" + config.getOrDefault("translatorFeatures", "");
    }
}

