/*
 * Decompiled with CFR 0.152.
 */
package jflex.state;

import java.util.Iterator;
import jflex.state.StateSetEnumerator;

public final class StateSet
implements Iterable<Integer> {
    private final boolean DEBUG = false;
    public static final StateSet EMPTY = new StateSet();
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public StateSet() {
        this(256);
    }

    public StateSet(int size) {
        this.bits = new long[StateSet.size2nbits(size)];
    }

    public StateSet(int size, int state) {
        this(size);
        this.addState(state);
    }

    public StateSet(StateSet set) {
        this.bits = new long[set.bits.length];
        System.arraycopy(set.bits, 0, this.bits, 0, set.bits.length);
    }

    public static StateSet emptySet(int length) {
        return new StateSet(StateSet.nbits2size(length));
    }

    public void addState(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            this.resize(state);
        }
        int n = index;
        this.bits[n] = this.bits[n] | 1L << (state & 0x3F);
    }

    static int size2nbits(int size) {
        return (size >> 6) + 1;
    }

    static int nbits2size(int length) {
        return length - 1 << 6;
    }

    private void resize(int size) {
        int needed = StateSet.size2nbits(size);
        long[] newbits = new long[Math.max(this.bits.length * 4, needed)];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void clear() {
        int l = this.bits.length;
        for (int i = 0; i < l; ++i) {
            this.bits[i] = 0L;
        }
    }

    public boolean hasElement(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return false;
        }
        return (this.bits[index] & 1L << (state & 0x3F)) != 0L;
    }

    public int getAndRemoveElement() {
        int i = 0;
        int o = 0;
        long m = 1L;
        while (this.bits[i] == 0L) {
            ++i;
        }
        while ((this.bits[i] & m) == 0L) {
            m <<= 1;
            ++o;
        }
        int n = i;
        this.bits[n] = this.bits[n] & (m ^ 0xFFFFFFFFFFFFFFFFL);
        return (i << 6) + o;
    }

    public void remove(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return;
        }
        int n = index;
        this.bits[n] = this.bits[n] & (1L << (state & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void intersect(StateSet set) {
        if (set == null) {
            this.clear();
        } else {
            int i;
            int l = Math.min(this.bits.length, set.bits.length);
            for (i = 0; i < l; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & set.bits[i];
            }
            for (i = l; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }
    }

    public StateSet complement(StateSet univ) {
        if (univ == null) {
            return null;
        }
        StateSet result = StateSet.emptySet(univ.bits.length);
        int m = Math.min(this.bits.length, univ.bits.length);
        for (int i = 0; i < m; ++i) {
            result.bits[i] = (this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL) & univ.bits[i];
        }
        if (this.bits.length < univ.bits.length) {
            System.arraycopy(univ.bits, m, result.bits, m, result.bits.length - m);
        }
        return result;
    }

    public void add(StateSet set) {
        long[] this_bits;
        if (set == null) {
            return;
        }
        long[] add_bits = set.bits;
        int add_bits_length = add_bits.length;
        if (this.bits.length < add_bits_length) {
            this_bits = new long[add_bits_length];
            System.arraycopy(this.bits, 0, this_bits, 0, this.bits.length);
        } else {
            this_bits = this.bits;
        }
        for (int i = 0; i < add_bits_length; ++i) {
            int n = i;
            this_bits[n] = this_bits[n] | add_bits[i];
        }
        this.bits = this_bits;
    }

    public boolean equals(Object b) {
        int i;
        if (!(b instanceof StateSet)) {
            return false;
        }
        StateSet set = (StateSet)b;
        int l1 = this.bits.length;
        int l2 = set.bits.length;
        if (l1 <= l2) {
            for (i = 0; i < l1; ++i) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            while (i < l2) {
                if (set.bits[i++] == 0L) continue;
                return false;
            }
        } else {
            while (i < l2) {
                if (this.bits[i] != set.bits[i]) {
                    return false;
                }
                ++i;
            }
            while (i < l1) {
                if (this.bits[i++] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        long h = 1234L;
        long[] _bits = this.bits;
        for (i = this.bits.length - 1; i >= 0 && _bits[i] == 0L; --i) {
        }
        while (i >= 0) {
            h ^= _bits[i--] * (long)i;
        }
        return (int)(h >> 32 ^ h);
    }

    public StateSetEnumerator states() {
        return new StateSetEnumerator(this);
    }

    public boolean containsElements() {
        for (long bit : this.bits) {
            if (bit == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean contains(StateSet set) {
        int i;
        if (set.bits.length > this.bits.length) {
            for (i = this.bits.length; i < set.bits.length; ++i) {
                if (set.bits[i] == 0L) continue;
                return false;
            }
        }
        for (i = 0; i < Math.min(this.bits.length, set.bits.length); ++i) {
            if ((this.bits[i] | set.bits[i]) == this.bits[i]) continue;
            return false;
        }
        return true;
    }

    public StateSet copy() {
        StateSet set = StateSet.emptySet(this.bits.length);
        System.arraycopy(this.bits, 0, set.bits, 0, this.bits.length);
        return set;
    }

    public void copy(StateSet set) {
        if (set == null) {
            this.clear();
        } else {
            if (this.bits.length < set.bits.length) {
                this.bits = new long[set.bits.length];
            } else {
                for (int i = set.bits.length; i < this.bits.length; ++i) {
                    this.bits[i] = 0L;
                }
            }
            System.arraycopy(set.bits, 0, this.bits, 0, Math.min(this.bits.length, set.bits.length));
        }
    }

    public String toString() {
        StateSetEnumerator set = this.states();
        StringBuilder result = new StringBuilder("{");
        if (set.hasMoreElements()) {
            result.append("" + set.nextElement());
        }
        while (set.hasMoreElements()) {
            int i = set.nextElement();
            result.append(", ").append(i);
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.states();
    }
}

