/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class BatchConditionQuery
extends ConditionQuery {
    private Condition.Relation in = null;
    private final int batchSize;

    public BatchConditionQuery(HugeType resultType, int batchSize) {
        super(resultType);
        this.batchSize = batchSize;
    }

    public void mergeToIN(ConditionQuery query, HugeKeys key) {
        Object value = query.condition((Object)key);
        if (this.in == null) {
            assert (!this.containsRelation(Condition.RelationType.IN));
            this.resetConditions(InsertionOrderUtil.newList((List)((List)query.conditions())));
            this.unsetCondition((Object)key);
            ArrayList list = new ArrayList(this.batchSize);
            list.add(value);
            this.in = (Condition.Relation)Condition.in(key, list);
            this.query(this.in);
        } else {
            E.checkArgument((boolean)this.in.key().equals((Object)key), (String)"Invalid key '%s'", (Object[])new Object[]{key});
            E.checkArgument((boolean)this.sameQueryExceptKeyIN(query), (String)"Can't merge query with different keys", (Object[])new Object[0]);
            List values = (List)this.in.value();
            values.add(value);
        }
    }

    protected boolean sameQueryExceptKeyIN(ConditionQuery query) {
        List<Condition.Relation> relations = query.relations();
        if (relations.size() != this.relations().size()) {
            return false;
        }
        for (Condition.Relation r : this.relations()) {
            Object key;
            if (r.relation() == Condition.RelationType.IN || Objects.equals(this.condition(key = r.key()), query.condition(key))) continue;
            return false;
        }
        return true;
    }
}

