/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.GraphSerializer;
import org.apache.hugegraph.backend.serializer.SchemaSerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;

public abstract class AbstractSerializer
implements GraphSerializer,
SchemaSerializer {
    protected HugeConfig config;

    public AbstractSerializer() {
    }

    public AbstractSerializer(HugeConfig config) {
        this.config = config;
    }

    protected BackendEntry convertEntry(BackendEntry entry) {
        return entry;
    }

    protected abstract BackendEntry newBackendEntry(HugeType var1, Id var2);

    protected abstract Id writeQueryId(HugeType var1, Id var2);

    protected abstract Query writeQueryEdgeCondition(Query var1);

    protected abstract Query writeQueryCondition(Query var1);

    @Override
    public Query writeQuery(Query query) {
        Query result;
        HugeType type = query.resultType();
        if (type.isEdge() && query.conditionsSize() > 0) {
            if (query.idsSize() > 0) {
                throw new BackendException("Not supported query edge by id and by condition at the same time");
            }
            result = this.writeQueryEdgeCondition(query);
            if (result != null) {
                return result;
            }
        }
        if (query.idsSize() == 1 && query instanceof IdQuery.OneIdQuery) {
            result = (IdQuery.OneIdQuery)query.copy();
            ((IdQuery.OneIdQuery)result).resetId(this.writeQueryId(type, ((IdQuery.OneIdQuery)result).id()));
            query = result;
        } else if (query.idsSize() > 0 && query instanceof IdQuery) {
            result = (IdQuery)query.copy();
            ((IdQuery)result).resetIds();
            for (Id id : query.ids()) {
                ((IdQuery)result).query(this.writeQueryId(type, id));
            }
            query = result;
        }
        if (query instanceof ConditionQuery && query.conditionsSize() > 0) {
            query = this.writeQueryCondition(query);
        }
        return query;
    }
}

