/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.structure.HugeVertexProperty;
import org.apache.hugegraph.type.define.HugeKeys;

public class BinaryScatterSerializer
extends BinarySerializer {
    public BinaryScatterSerializer(HugeConfig config) {
        super(true, true, false);
    }

    @Override
    public BackendEntry writeVertex(HugeVertex vertex) {
        BinaryBackendEntry entry = this.newBackendEntry(vertex);
        if (vertex.removed()) {
            return entry;
        }
        entry.column(this.formatLabel(vertex));
        for (HugeProperty<?> prop : vertex.getProperties()) {
            entry.column(this.formatProperty(prop));
        }
        return entry;
    }

    @Override
    public HugeVertex readVertex(HugeGraph graph, BackendEntry bytesEntry) {
        if (bytesEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        byte[] VL = this.formatSyspropName(entry.id(), HugeKeys.LABEL);
        BackendEntry.BackendColumn vl = entry.column(VL);
        VertexLabel vertexLabel = VertexLabel.NONE;
        if (vl != null) {
            Id labelId = BytesBuffer.wrap(vl.value).readId();
            vertexLabel = graph.vertexLabelOrNone(labelId);
        }
        Id id = entry.id().origin();
        HugeVertex vertex = new HugeVertex(graph, id, vertexLabel);
        for (BackendEntry.BackendColumn col : entry.columns()) {
            this.parseColumn(col, vertex);
        }
        return vertex;
    }

    @Override
    public BackendEntry writeVertexProperty(HugeVertexProperty<?> prop) {
        BinaryBackendEntry entry = this.newBackendEntry(prop.element());
        entry.column(this.formatProperty(prop));
        entry.subId(IdGenerator.of(prop.key()));
        return entry;
    }
}

