/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class BackendStoreInfo {
    private static final Logger LOG = Log.logger(BackendStoreInfo.class);
    private final BackendStoreProvider storeProvider;
    private final HugeConfig config;

    public BackendStoreInfo(HugeConfig config, BackendStoreProvider storeProvider) {
        this.config = config;
        this.storeProvider = storeProvider;
    }

    public boolean exists() {
        return this.storeProvider.initialized();
    }

    public boolean checkVersion() {
        String storedVersion;
        String driverVersion = this.storeProvider.driverVersion();
        if (!driverVersion.equals(storedVersion = this.storeProvider.loadSystemStore(this.config).storedVersion())) {
            LOG.error("The backend driver version '{}' is inconsistent with the data version '{}' of backend store for graph '{}'", new Object[]{driverVersion, storedVersion, this.storeProvider.graph()});
            return false;
        }
        return true;
    }
}

