/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.memory;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.serializer.TextBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class InMemoryDBTable
extends BackendTable<BackendSession, TextBackendEntry> {
    private static final Logger LOG = Log.logger(InMemoryDBTable.class);
    protected final Map<Id, BackendEntry> store;
    private final InMemoryShardSplitter shardSplitter;

    public InMemoryDBTable(HugeType type) {
        super(type.name());
        this.store = new ConcurrentHashMap<Id, BackendEntry>();
        this.shardSplitter = new InMemoryShardSplitter(this.table());
    }

    public InMemoryDBTable(HugeType type, Map<Id, BackendEntry> store) {
        super(type.name());
        this.store = store;
        this.shardSplitter = new InMemoryShardSplitter(this.table());
    }

    @Override
    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSplitter.getSplits(session, splitSize);
        });
    }

    protected Map<Id, BackendEntry> store() {
        return this.store;
    }

    @Override
    public void init(BackendSession session) {
    }

    @Override
    public void clear(BackendSession session) {
        this.store.clear();
    }

    @Override
    public void insert(BackendSession session, TextBackendEntry entry) {
        if (!this.store.containsKey(entry.id())) {
            this.store.put(entry.id(), entry);
        } else {
            BackendEntry origin = this.store.get(entry.id());
            origin.merge(entry);
        }
    }

    @Override
    public void delete(BackendSession session, TextBackendEntry entry) {
        this.store.remove(entry.id());
    }

    @Override
    public void append(BackendSession session, TextBackendEntry entry) {
        BackendEntry parent = this.store.get(entry.id());
        if (parent == null) {
            this.store.put(entry.id(), entry);
        } else {
            ((TextBackendEntry)parent).append(entry);
        }
    }

    @Override
    public void eliminate(BackendSession session, TextBackendEntry entry) {
        BackendEntry parent = this.store.get(entry.id());
        if (parent != null) {
            ((TextBackendEntry)parent).eliminate(entry);
        }
    }

    @Override
    public boolean queryExist(BackendSession session, TextBackendEntry entry) {
        ImmutableList ids = ImmutableList.of((Object)entry.id());
        return !this.queryById((Collection<Id>)ids, this.store).isEmpty();
    }

    @Override
    public Number queryNumber(BackendSession session, Query query) {
        Aggregate aggregate = query.aggregateNotNull();
        if (aggregate.func() != Aggregate.AggregateFunc.COUNT) {
            throw new NotSupportException(aggregate.toString());
        }
        assert (aggregate.func() == Aggregate.AggregateFunc.COUNT);
        Iterator<BackendEntry> results = this.query(session, query);
        long total = 0L;
        while (results.hasNext()) {
            total += this.sizeOfBackendEntry(results.next());
        }
        return total;
    }

    @Override
    public Iterator<BackendEntry> query(BackendSession session, Query query) {
        String page = query.page();
        if (page != null && !page.isEmpty()) {
            throw new NotSupportException("paging by InMemoryDBStore");
        }
        Map<Id, BackendEntry> rs = this.store;
        if (query instanceof IdPrefixQuery) {
            IdPrefixQuery pq = (IdPrefixQuery)query;
            rs = this.queryByIdPrefix(pq.start(), pq.inclusiveStart(), pq.prefix(), rs);
        }
        if (query instanceof IdRangeQuery) {
            IdRangeQuery rq = (IdRangeQuery)query;
            rs = this.queryByIdRange(rq.start(), rq.inclusiveStart(), rq.end(), rq.inclusiveEnd(), rs);
        }
        if (query.idsSize() > 0) {
            rs = this.queryById(query.ids(), rs);
        }
        if (query.conditionsSize() > 0) {
            ConditionQuery condQuery = (ConditionQuery)query;
            if (condQuery.containsScanRelation()) {
                return this.queryByRange(condQuery);
            }
            rs = this.queryByFilter(query.conditions(), rs);
        }
        Iterator<BackendEntry> iterator = rs.values().iterator();
        long offset = query.offset() - query.actualOffset();
        if (offset >= (long)rs.size()) {
            query.goOffset(rs.size());
            return QueryResults.emptyIterator();
        }
        if (offset > 0L) {
            query.goOffset(offset);
            iterator = this.skipOffset(iterator, offset);
        }
        if (!query.noLimit() && query.total() < (long)rs.size()) {
            iterator = this.dropTails(iterator, query.limit());
        }
        return iterator;
    }

    private Iterator<BackendEntry> queryByRange(ConditionQuery query) {
        E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
        Condition.Relation scan = query.relations().iterator().next();
        Shard shard = (Shard)scan.value();
        int start = Strings.isNullOrEmpty((String)shard.start()) ? 0 : Long.valueOf(shard.start()).intValue();
        int end = Strings.isNullOrEmpty((String)shard.end()) ? 0 : Long.valueOf(shard.end()).intValue();
        ArrayList<BackendEntry> rs = new ArrayList<BackendEntry>(end - start);
        Iterator<BackendEntry> iterator = this.store.values().iterator();
        int i = 0;
        while (iterator.hasNext() && i++ < end) {
            BackendEntry entry = iterator.next();
            if (i <= start) continue;
            rs.add(entry);
        }
        return rs.iterator();
    }

    protected Map<Id, BackendEntry> queryById(Collection<Id> ids, Map<Id, BackendEntry> entries) {
        assert (!ids.isEmpty());
        Map rs = InsertionOrderUtil.newMap();
        for (Id id : ids) {
            assert (!id.number());
            if (!entries.containsKey(id)) continue;
            rs.put(id, entries.get(id));
        }
        return rs;
    }

    protected Map<Id, BackendEntry> queryByIdPrefix(Id start, boolean inclusiveStart, Id prefix, Map<Id, BackendEntry> rs) {
        throw new BackendException("Unsupported prefix query: " + prefix);
    }

    protected Map<Id, BackendEntry> queryByIdRange(Id start, boolean inclusiveStart, Id end, boolean inclusiveEnd, Map<Id, BackendEntry> rs) {
        throw new BackendException("Unsupported range query: " + start);
    }

    protected Map<Id, BackendEntry> queryByFilter(Collection<Condition> conditions, Map<Id, BackendEntry> entries) {
        assert (!conditions.isEmpty());
        HashMap<Id, BackendEntry> rs = new HashMap<Id, BackendEntry>();
        LOG.trace("queryByFilter {} size = {}", (Object)this.table(), (Object)entries.size());
        for (BackendEntry entry : entries.values()) {
            boolean matched = true;
            for (Condition c : conditions) {
                if (InMemoryDBTable.matchCondition(entry, c)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            rs.put(entry.id(), entry);
        }
        return rs;
    }

    protected Iterator<BackendEntry> skipOffset(Iterator<BackendEntry> iterator, long offset) {
        for (long i = 0L; i < offset && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return iterator;
    }

    protected Iterator<BackendEntry> dropTails(Iterator<BackendEntry> iterator, long limit) {
        E.checkArgument((limit <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Limit must be <= 0x7fffffff, but got '%s'", (Object[])new Object[]{limit});
        ArrayList<BackendEntry> entries = new ArrayList<BackendEntry>((int)limit);
        for (long i = 0L; i < limit && iterator.hasNext(); ++i) {
            entries.add(iterator.next());
        }
        return entries.iterator();
    }

    protected long sizeOfBackendEntry(BackendEntry entry) {
        return 1L;
    }

    private static boolean matchCondition(BackendEntry item, Condition c) {
        TextBackendEntry entry = (TextBackendEntry)item;
        if (!(c instanceof Condition.Relation)) {
            throw new BackendException("Unsupported condition: " + c);
        }
        Condition.Relation r = (Condition.Relation)c;
        String key = r.serialKey().toString();
        if (r.relation() == Condition.RelationType.CONTAINS_KEY) {
            return entry.contains(r.serialValue().toString());
        }
        if (r.relation() == Condition.RelationType.CONTAINS_VALUE) {
            return entry.containsValue(r.serialValue().toString());
        }
        if (r.relation() == Condition.RelationType.EQ) {
            return entry.contains(key, r.serialValue().toString());
        }
        if (entry.contains(key)) {
            return r.test(entry.column(key));
        }
        return false;
    }

    private class InMemoryShardSplitter
    extends BackendTable.ShardSplitter<BackendSession> {
        public InMemoryShardSplitter(String table) {
            super(table);
        }

        @Override
        protected long maxKey() {
            return InMemoryDBTable.this.store.size();
        }

        @Override
        protected long estimateDataSize(BackendSession session) {
            return 0L;
        }

        @Override
        protected long estimateNumKeys(BackendSession session) {
            return InMemoryDBTable.this.store.size();
        }
    }
}

