/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.remoting.rpc.RpcServer;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.ReadOnlyOption;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.impl.BoltRpcServer;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.raft.RaftBackendStore;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.RaftGroupManagerImpl;
import org.apache.hugegraph.backend.store.raft.RaftNode;
import org.apache.hugegraph.backend.store.raft.compress.CompressStrategyManager;
import org.apache.hugegraph.backend.store.raft.rpc.AddPeerProcessor;
import org.apache.hugegraph.backend.store.raft.rpc.ListPeersProcessor;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.backend.store.raft.rpc.RemovePeerProcessor;
import org.apache.hugegraph.backend.store.raft.rpc.RpcForwarder;
import org.apache.hugegraph.backend.store.raft.rpc.SetLeaderProcessor;
import org.apache.hugegraph.backend.store.raft.rpc.StoreCommandProcessor;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class RaftContext {
    private static final Logger LOG = Log.logger(RaftContext.class);
    public static final int NO_TIMEOUT = -1;
    public static final int POLL_INTERVAL = 5000;
    public static final int WAIT_RAFTLOG_TIMEOUT = 1800000;
    public static final int WAIT_LEADER_TIMEOUT = 600000;
    public static final int BUSY_MIN_SLEEP_FACTOR = 3000;
    public static final int BUSY_MAX_SLEEP_FACTOR = 5000;
    public static final int WAIT_RPC_TIMEOUT = 1800000;
    public static final int LOG_WARN_INTERVAL = 60000;
    public static final int BLOCK_SIZE = 8192;
    public static final int QUEUE_SIZE = CoreOptions.CPUS;
    public static final long KEEP_ALIVE_SECOND = 300L;
    private final HugeGraphParams params;
    private final Configuration groupPeers;
    private final RaftBackendStore[] stores;
    private final ExecutorService readIndexExecutor;
    private final ExecutorService snapshotExecutor;
    private final ExecutorService backendExecutor;
    private com.alipay.sofa.jraft.rpc.RpcServer raftRpcServer;
    private PeerId endpoint;
    private RaftNode raftNode;
    private RaftGroupManager raftGroupManager;
    private RpcForwarder rpcForwarder;

    public RaftContext(HugeGraphParams params) {
        int threads;
        this.params = params;
        HugeConfig config = params.configuration();
        String groupPeersString = this.config().getString("raft.group_peers");
        E.checkArgument((groupPeersString != null ? 1 : 0) != 0, (String)"Please ensure config `raft.group_peers` in raft mode", (Object[])new Object[0]);
        this.groupPeers = new Configuration();
        if (!this.groupPeers.parse(groupPeersString)) {
            throw new HugeException("Failed to parse raft.group_peers: '%s'", groupPeersString);
        }
        this.stores = new RaftBackendStore[RaftRequests.StoreType.ALL.getNumber()];
        if (((Boolean)config.get(CoreOptions.RAFT_SAFE_READ)).booleanValue()) {
            threads = (Integer)config.get(CoreOptions.RAFT_READ_INDEX_THREADS);
            this.readIndexExecutor = this.createReadIndexExecutor(threads);
        } else {
            this.readIndexExecutor = null;
        }
        threads = (Integer)config.get(CoreOptions.RAFT_SNAPSHOT_THREADS);
        this.snapshotExecutor = this.createSnapshotExecutor(threads);
        threads = (Integer)config.get(CoreOptions.RAFT_BACKEND_THREADS);
        this.backendExecutor = this.createBackendExecutor(threads);
        CompressStrategyManager.init(config);
        this.raftRpcServer = null;
        this.endpoint = null;
        this.raftNode = null;
        this.raftGroupManager = null;
        this.rpcForwarder = null;
    }

    public void initRaftNode(RpcServer rpcServer) {
        this.raftRpcServer = this.wrapRpcServer(rpcServer);
        this.endpoint = new PeerId(rpcServer.ip(), rpcServer.port());
        this.registerRpcRequestProcessors();
        LOG.info("Start raft server successfully: {}", (Object)this.endpoint());
        this.raftNode = new RaftNode(this);
        this.rpcForwarder = new RpcForwarder(this.raftNode.node());
        this.raftGroupManager = new RaftGroupManagerImpl(this);
    }

    public void waitRaftNodeStarted() {
        RaftNode node = this.node();
        node.waitLeaderElected(600000);
        node.waitRaftLogSynced(-1);
    }

    public void close() {
        LOG.info("Stop raft server: {}", (Object)this.endpoint());
        RaftNode node = this.node();
        if (node != null) {
            node.shutdown();
        }
        this.shutdownRpcServer();
    }

    public RaftNode node() {
        return this.raftNode;
    }

    com.alipay.sofa.jraft.rpc.RpcServer rpcServer() {
        return this.raftRpcServer;
    }

    RpcForwarder rpcForwarder() {
        return this.rpcForwarder;
    }

    public RaftGroupManager raftNodeManager() {
        return this.raftGroupManager;
    }

    public String group() {
        return this.params.name();
    }

    public void addStore(RaftRequests.StoreType type, RaftBackendStore store) {
        this.stores[type.getNumber()] = store;
    }

    public RaftRequests.StoreType storeType(String store) {
        if ("m".equals(store)) {
            return RaftRequests.StoreType.SCHEMA;
        }
        if ("g".equals(store)) {
            return RaftRequests.StoreType.GRAPH;
        }
        assert ("s".equals(store));
        return RaftRequests.StoreType.SYSTEM;
    }

    RaftBackendStore[] stores() {
        return this.stores;
    }

    public BackendStore originStore(RaftRequests.StoreType storeType) {
        RaftBackendStore raftStore = this.stores[storeType.getNumber()];
        E.checkState((raftStore != null ? 1 : 0) != 0, (String)"The raft store of type %s shouldn't be null", (Object[])new Object[]{storeType});
        return raftStore.originStore();
    }

    public NodeOptions nodeOptions() throws IOException {
        HugeConfig config = this.config();
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setEnableMetrics(false);
        nodeOptions.setRpcProcessorThreadPoolSize(((Integer)config.get(CoreOptions.RAFT_RPC_THREADS)).intValue());
        nodeOptions.setRpcConnectTimeoutMs(((Integer)config.get(CoreOptions.RAFT_RPC_CONNECT_TIMEOUT)).intValue());
        nodeOptions.setRpcDefaultTimeout(1000 * (Integer)config.get(CoreOptions.RAFT_RPC_TIMEOUT));
        nodeOptions.setRpcInstallSnapshotTimeout(1000 * (Integer)config.get(CoreOptions.RAFT_INSTALL_SNAPSHOT_TIMEOUT));
        int electionTimeout = (Integer)config.get(CoreOptions.RAFT_ELECTION_TIMEOUT);
        nodeOptions.setElectionTimeoutMs(electionTimeout);
        nodeOptions.setDisableCli(false);
        int snapshotInterval = (Integer)config.get(CoreOptions.RAFT_SNAPSHOT_INTERVAL);
        nodeOptions.setSnapshotIntervalSecs(snapshotInterval);
        nodeOptions.setInitialConf(this.groupPeers);
        String raftPath = (String)config.get(CoreOptions.RAFT_PATH);
        String logUri = Paths.get(raftPath, "log").toString();
        FileUtils.forceMkdir((File)new File(logUri));
        nodeOptions.setLogUri(logUri);
        String metaUri = Paths.get(raftPath, "meta").toString();
        FileUtils.forceMkdir((File)new File(metaUri));
        nodeOptions.setRaftMetaUri(metaUri);
        String snapshotUri = Paths.get(raftPath, "snapshot").toString();
        FileUtils.forceMkdir((File)new File(snapshotUri));
        nodeOptions.setSnapshotUri(snapshotUri);
        RaftOptions raftOptions = nodeOptions.getRaftOptions();
        raftOptions.setApplyBatch(((Integer)config.get(CoreOptions.RAFT_APPLY_BATCH)).intValue());
        raftOptions.setDisruptorBufferSize(((Integer)config.get(CoreOptions.RAFT_QUEUE_SIZE)).intValue());
        raftOptions.setDisruptorPublishEventWaitTimeoutSecs(((Integer)config.get(CoreOptions.RAFT_QUEUE_PUBLISH_TIMEOUT)).intValue());
        raftOptions.setReplicatorPipeline(((Boolean)config.get(CoreOptions.RAFT_REPLICATOR_PIPELINE)).booleanValue());
        raftOptions.setOpenStatistics(false);
        raftOptions.setReadOnlyOptions(ReadOnlyOption.valueOf((String)((String)config.get(CoreOptions.RAFT_READ_STRATEGY))));
        return nodeOptions;
    }

    void clearCache() {
        this.notifyCache("clear", HugeType.VERTEX_LABEL, null);
        this.notifyCache("clear", HugeType.VERTEX, null);
    }

    void updateCacheIfNeeded(BackendMutation mutation, boolean forwarded) {
        if (this.graphMode() != GraphMode.NONE) {
            return;
        }
        if (!forwarded && this.node().selfIsLeader()) {
            return;
        }
        for (HugeType type : mutation.types()) {
            ArrayList<Id> ids = new ArrayList<Id>(500);
            if (!type.isSchema() && !type.isGraph()) continue;
            Iterator<BackendAction> it = mutation.mutation(type);
            while (it.hasNext()) {
                ids.add(it.next().entry().originId());
            }
            this.notifyCache("invalid", type, ids);
        }
    }

    private void notifyCache(String action, HugeType type, List<Id> ids) {
        EventHub eventHub;
        if (type.isGraph()) {
            eventHub = this.params.graphEventHub();
        } else if (type.isSchema()) {
            eventHub = this.params.schemaEventHub();
        } else {
            return;
        }
        try {
            if (ids == null) {
                eventHub.call("cache", new Object[]{action, type});
            } else if (ids.size() == 1) {
                eventHub.call("cache", new Object[]{action, type, ids.get(0)});
            } else {
                eventHub.call("cache", new Object[]{action, type, ids.toArray()});
            }
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Can't update cache due to EventHub is too busy");
        }
    }

    public PeerId endpoint() {
        return this.endpoint;
    }

    public boolean safeRead() {
        return (Boolean)this.config().get(CoreOptions.RAFT_SAFE_READ);
    }

    public ExecutorService snapshotExecutor() {
        return this.snapshotExecutor;
    }

    public ExecutorService backendExecutor() {
        return this.backendExecutor;
    }

    public ExecutorService readIndexExecutor() {
        return this.readIndexExecutor;
    }

    public GraphMode graphMode() {
        return this.params.mode();
    }

    private HugeConfig config() {
        return this.params.configuration();
    }

    private com.alipay.sofa.jraft.rpc.RpcServer initAndStartRpcServer() {
        Integer lowWaterMark = (Integer)this.config().get(CoreOptions.RAFT_RPC_BUF_LOW_WATER_MARK);
        System.setProperty("bolt.channel_write_buf_low_water_mark", String.valueOf(lowWaterMark));
        Integer highWaterMark = (Integer)this.config().get(CoreOptions.RAFT_RPC_BUF_HIGH_WATER_MARK);
        System.setProperty("bolt.channel_write_buf_high_water_mark", String.valueOf(highWaterMark));
        PeerId endpoint = this.endpoint();
        NodeManager.getInstance().addAddress(endpoint.getEndpoint());
        com.alipay.sofa.jraft.rpc.RpcServer rpcServer = RaftRpcServerFactory.createAndStartRaftRpcServer((Endpoint)endpoint.getEndpoint());
        LOG.info("Raft-RPC server is started successfully");
        return rpcServer;
    }

    private com.alipay.sofa.jraft.rpc.RpcServer wrapRpcServer(RpcServer rpcServer) {
        Integer lowWaterMark = (Integer)this.config().get(CoreOptions.RAFT_RPC_BUF_LOW_WATER_MARK);
        System.setProperty("bolt.channel_write_buf_low_water_mark", String.valueOf(lowWaterMark));
        Integer highWaterMark = (Integer)this.config().get(CoreOptions.RAFT_RPC_BUF_HIGH_WATER_MARK);
        System.setProperty("bolt.channel_write_buf_high_water_mark", String.valueOf(highWaterMark));
        BoltRpcServer raftRpcServer = new BoltRpcServer(rpcServer);
        RaftRpcServerFactory.addRaftRequestProcessors((com.alipay.sofa.jraft.rpc.RpcServer)raftRpcServer);
        return raftRpcServer;
    }

    private void shutdownRpcServer() {
        this.raftRpcServer.shutdown();
        PeerId endpoint = this.endpoint();
        NodeManager.getInstance().removeAddress(endpoint.getEndpoint());
    }

    private void registerRpcRequestProcessors() {
        this.raftRpcServer.registerProcessor((RpcProcessor)new AddPeerProcessor(this));
        this.raftRpcServer.registerProcessor((RpcProcessor)new RemovePeerProcessor(this));
        this.raftRpcServer.registerProcessor((RpcProcessor)new StoreCommandProcessor(this));
        this.raftRpcServer.registerProcessor((RpcProcessor)new SetLeaderProcessor(this));
        this.raftRpcServer.registerProcessor((RpcProcessor)new ListPeersProcessor(this));
    }

    private ExecutorService createReadIndexExecutor(int coreThreads) {
        int maxThreads = coreThreads << 2;
        String name = "store-read-index-callback";
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        return RaftContext.newPool(coreThreads, maxThreads, name, handler);
    }

    private ExecutorService createSnapshotExecutor(int coreThreads) {
        int maxThreads = coreThreads << 2;
        String name = "store-snapshot-executor";
        ThreadPoolExecutor.CallerRunsPolicy handler = new ThreadPoolExecutor.CallerRunsPolicy();
        return RaftContext.newPool(coreThreads, maxThreads, name, handler);
    }

    private ExecutorService createBackendExecutor(int threads) {
        String name = "store-backend-executor";
        ThreadPoolExecutor.CallerRunsPolicy handler = new ThreadPoolExecutor.CallerRunsPolicy();
        return RaftContext.newPool(threads, threads, name, handler);
    }

    private static ExecutorService newPool(int coreThreads, int maxThreads, String name, RejectedExecutionHandler handler) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(QUEUE_SIZE);
        return ThreadPoolUtil.newBuilder().poolName(name).enableMetric(Boolean.valueOf(false)).coreThreads(Integer.valueOf(coreThreads)).maximumThreads(Integer.valueOf(maxThreads)).keepAliveSeconds(Long.valueOf(300L)).workQueue(queue).threadFactory((ThreadFactory)new NamedThreadFactory(name, true)).rejectedHandler(handler).build();
    }
}

