/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public abstract class AbstractCentAlgorithm
extends AbstractAlgorithm {
    private static final Logger LOG = Log.logger(AbstractCentAlgorithm.class);

    @Override
    public String category() {
        return "centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        AbstractCentAlgorithm.depth(parameters);
        AbstractCentAlgorithm.degree(parameters);
        AbstractCentAlgorithm.sample(parameters);
        AbstractCentAlgorithm.direction(parameters);
        AbstractCentAlgorithm.edgeLabel(parameters);
        AbstractCentAlgorithm.sourceSample(parameters);
        AbstractCentAlgorithm.sourceLabel(parameters);
        AbstractCentAlgorithm.sourceCLabel(parameters);
        AbstractCentAlgorithm.top(parameters);
    }

    protected static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        protected GraphTraversal<Vertex, Vertex> constructSource(String sourceLabel, long sourceSample, String sourceCLabel) {
            GraphTraversal t = this.graph().traversal().withSack((Object)Float.valueOf(1.0f)).V(new Object[0]);
            if (sourceLabel != null) {
                t = t.hasLabel(sourceLabel, new String[0]);
            }
            t = t.filter(it -> {
                this.updateProgress(++this.progress);
                return sourceCLabel == null || this.match((Element)it.get(), sourceCLabel);
            });
            if (sourceSample > 0L) {
                t = t.sample((int)sourceSample);
            }
            return t;
        }

        protected GraphTraversal<Vertex, Vertex> constructPath(GraphTraversal<Vertex, Vertex> t, Directions dir, String label, long degree, long sample, String sourceLabel, String sourceCLabel) {
            GraphTraversal<Vertex, Vertex> unit = this.constructPathUnit(dir, label, degree, sample, sourceLabel, sourceCLabel);
            t = t.as("v", new String[0]).repeat((Traversal)__.local(unit).simplePath().as("v", new String[0]));
            return t;
        }

        protected GraphTraversal<Vertex, Vertex> constructPathUnit(Directions dir, String label, long degree, long sample, String sourceLabel, String sourceCLabel) {
            if (dir == null) {
                dir = Directions.BOTH;
            }
            Direction direction = dir.direction();
            String[] labels = new String[]{};
            if (label != null) {
                labels = new String[]{label};
            }
            GraphTraversal unit = __.to((Direction)direction, (String[])labels);
            if (sourceLabel != null) {
                unit = unit.hasLabel(sourceLabel, new String[0]);
            }
            if (sourceCLabel != null) {
                unit = unit.has("c_label", (Object)sourceCLabel);
            }
            if (degree != -1L) {
                unit = unit.limit(degree);
            }
            if (sample > 0L) {
                unit = unit.sample((int)sample);
            }
            return unit;
        }

        protected <V> GraphTraversal<V, V> filterNonShortestPath(GraphTraversal<V, V> t, boolean keepOneShortestPath) {
            long size = (Long)this.graph().traversal().V(new Object[0]).limit(100000L).count().next();
            HashMap triples = new HashMap((int)size);
            return t.filter(it -> {
                Id start = ((HugeElement)it.path(Pop.first, "v")).id();
                Id end = ((HugeElement)it.path(Pop.last, "v")).id();
                int len = it.path().size();
                assert (len == ((List)it.path(Pop.all, "v")).size());
                Pair key = Pair.of((Object)start, (Object)end);
                Integer shortest = (Integer)triples.get(key);
                if (shortest != null && len > shortest) {
                    return false;
                }
                if (shortest != null) {
                    assert (len == shortest);
                    return !keepOneShortestPath;
                }
                triples.put(key, len);
                return true;
            });
        }

        protected GraphTraversal<Vertex, Id> substractPath(GraphTraversal<Vertex, Vertex> t, boolean withBoundary) {
            return t.select(Pop.all, "v").flatMap(it -> {
                List path = (List)it.get();
                if (withBoundary) {
                    Iterator items = path.iterator();
                    return new MapperIterator(items, HugeVertex::id);
                }
                int len = path.size();
                if (len < 3) {
                    return Collections.emptyIterator();
                }
                LOG.debug("CentAlgorithm substract path: {}", (Object)path);
                path.remove(path.size() - 1);
                path.remove(0);
                Iterator items = path.iterator();
                return new MapperIterator(items, HugeVertex::id);
            });
        }

        protected GraphTraversal<Vertex, ?> topN(GraphTraversal<Vertex, ?> t, long topN) {
            if (topN > 0L || topN == -1L) {
                t = t.order(Scope.local).by((Function)Column.values, (Comparator)Order.desc);
                if (topN > 0L) {
                    assert (topN != -1L);
                    t = t.limit(Scope.local, topN);
                }
            }
            return t;
        }
    }
}

