/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.SchemaTransaction;
import org.apache.hugegraph.job.schema.IndexLabelRemoveJob;
import org.apache.hugegraph.job.schema.SchemaJob;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.LockUtil;

public class VertexLabelRemoveJob
extends SchemaJob {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        VertexLabelRemoveJob.removeVertexLabel(this.params(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeVertexLabel(HugeGraphParams graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        SchemaTransaction schemaTx = graph.schemaTransaction();
        VertexLabel vertexLabel = schemaTx.getVertexLabel(id);
        if (vertexLabel == null) {
            return;
        }
        if (vertexLabel.status().deleting()) {
            LOG.info("The vertex label '{}' has been in {} status, please check if it's expected to delete it again", (Object)vertexLabel, (Object)vertexLabel.status());
        }
        List<EdgeLabel> edgeLabels = schemaTx.getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.linkWithLabel(id)) continue;
            throw new HugeException("Not allowed to remove vertex label '%s' because the edge label '%s' still link with it", vertexLabel.name(), edgeLabel.name());
        }
        ImmutableSet indexLabelIds = ImmutableSet.copyOf(vertexLabel.indexLabels());
        LockUtil.Locks locks = new LockUtil.Locks(graph.name());
        try {
            locks.lockWrites("vl_delete", id);
            schemaTx.updateSchemaStatus(vertexLabel, SchemaStatus.DELETING);
            try {
                for (Id ilId : indexLabelIds) {
                    IndexLabelRemoveJob.removeIndexLabel(graph, ilId);
                }
                graphTx.removeVertices(vertexLabel);
                graph.graph().tx().commit();
                VertexLabelRemoveJob.removeSchema(schemaTx, vertexLabel);
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(vertexLabel, SchemaStatus.UNDELETED);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }
}

