/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.util.E;

public class EdgeLabel
extends SchemaLabel {
    public static final EdgeLabel NONE = new EdgeLabel(null, NONE_ID, "~undefined");
    private Id sourceLabel = NONE_ID;
    private Id targetLabel = NONE_ID;
    private Frequency frequency = Frequency.DEFAULT;
    private List<Id> sortKeys = new ArrayList<Id>();

    public EdgeLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.EDGE_LABEL;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public void frequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public boolean directed() {
        return true;
    }

    public String sourceLabelName() {
        return this.graph.vertexLabelOrNone(this.sourceLabel).name();
    }

    public Id sourceLabel() {
        return this.sourceLabel;
    }

    public void sourceLabel(Id id) {
        E.checkArgument((this.sourceLabel == NONE_ID ? 1 : 0) != 0, (String)"Not allowed to set source label multi times of edge label '%s'", (Object[])new Object[]{this.name()});
        this.sourceLabel = id;
    }

    public String targetLabelName() {
        return this.graph.vertexLabelOrNone(this.targetLabel).name();
    }

    public Id targetLabel() {
        return this.targetLabel;
    }

    public void targetLabel(Id id) {
        E.checkArgument((this.targetLabel == NONE_ID ? 1 : 0) != 0, (String)"Not allowed to set target label multi times of edge label '%s'", (Object[])new Object[]{this.name()});
        this.targetLabel = id;
    }

    public boolean linkWithLabel(Id id) {
        return this.sourceLabel.equals(id) || this.targetLabel.equals(id);
    }

    public boolean linkWithVertexLabel(Id label, Directions dir) {
        if (dir.equals(Directions.IN)) {
            return this.targetLabel.equals(label);
        }
        if (dir.equals(Directions.OUT)) {
            return this.sourceLabel.equals(label);
        }
        if (dir.equals(Directions.BOTH)) {
            return this.targetLabel.equals(label) || this.sourceLabel.equals(label);
        }
        return false;
    }

    public boolean checkLinkEqual(Id sourceLabel, Id targetLabel) {
        return this.sourceLabel.equals(sourceLabel) && this.targetLabel.equals(targetLabel);
    }

    public boolean existSortKeys() {
        return !this.sortKeys.isEmpty();
    }

    public List<Id> sortKeys() {
        return Collections.unmodifiableList(this.sortKeys);
    }

    public void sortKey(Id id) {
        this.sortKeys.add(id);
    }

    public void sortKeys(Id ... ids) {
        this.sortKeys.addAll(Arrays.asList(ids));
    }

    public boolean hasSameContent(EdgeLabel other) {
        return super.hasSameContent(other) && this.frequency == other.frequency && Objects.equal((Object)this.sourceLabelName(), (Object)other.sourceLabelName()) && Objects.equal((Object)this.targetLabelName(), (Object)other.targetLabelName()) && Objects.equal(this.graph.mapPkId2Name(this.sortKeys), other.graph.mapPkId2Name(other.sortKeys));
    }

    public static EdgeLabel undefined(HugeGraph graph, Id id) {
        return new EdgeLabel(graph, id, "~undefined");
    }

    public static interface Builder
    extends SchemaBuilder<EdgeLabel> {
        public Id rebuildIndex();

        public Builder link(String var1, String var2);

        public Builder sourceLabel(String var1);

        public Builder targetLabel(String var1);

        public Builder singleTime();

        public Builder multiTimes();

        public Builder sortKeys(String ... var1);

        public Builder properties(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder frequency(Frequency var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

