/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.exception.LimitExceedException;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.job.EphemeralJob;
import org.apache.hugegraph.task.StandardTaskScheduler;
import org.apache.hugegraph.task.TaskCallable;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.slf4j.Logger;

public class HugeTask<V>
extends FutureTask<V> {
    private static final Logger LOG = Log.logger(HugeTask.class);
    private static final float DECOMPRESS_RATIO = 10.0f;
    private transient TaskScheduler scheduler = null;
    private final TaskCallable<V> callable;
    private String type;
    private String name;
    private final Id id;
    private final Id parent;
    private Set<Id> dependencies;
    private String description;
    private String context;
    private Date create;
    private Id server;
    private int load;
    private volatile TaskStatus status;
    private volatile int progress;
    private volatile Date update;
    private volatile int retries;
    private volatile String input;
    private volatile String result;

    public HugeTask(Id id, Id parent, String callable, String input) {
        this(id, parent, TaskCallable.fromClass(callable));
        this.input(input);
    }

    public HugeTask(Id id, Id parent, TaskCallable<V> callable) {
        super(callable);
        E.checkArgumentNotNull((Object)id, (String)"Task id can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)id.number(), (String)"Invalid task id type, it must be number", (Object[])new Object[0]);
        assert (callable != null);
        this.callable = callable;
        this.type = null;
        this.name = null;
        this.id = id;
        this.parent = parent;
        this.dependencies = null;
        this.description = null;
        this.context = null;
        this.status = TaskStatus.NEW;
        this.progress = 0;
        this.create = new Date();
        this.update = null;
        this.retries = 0;
        this.input = null;
        this.result = null;
        this.server = null;
        this.load = 1;
    }

    public Id id() {
        return this.id;
    }

    public Id parent() {
        return this.parent;
    }

    public Set<Id> dependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public void depends(Id id) {
        E.checkState((this.status == TaskStatus.NEW ? 1 : 0) != 0, (String)"Can't add dependency in status '%s'", (Object[])new Object[]{this.status});
        if (this.dependencies == null) {
            this.dependencies = InsertionOrderUtil.newSet();
        }
        this.dependencies.add(id);
    }

    public TaskStatus status() {
        return this.status;
    }

    public void type(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public void name(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public void description(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public final void context(String context) {
        E.checkArgument((this.context == null ? 1 : 0) != 0, (String)"Task context must be set once, but already set '%s'", (Object[])new Object[]{this.context});
        E.checkArgument((this.status == TaskStatus.NEW ? 1 : 0) != 0, (String)"Task context must be set in state NEW instead of %s", (Object[])new Object[]{this.status});
        this.context = context;
    }

    public final String context() {
        return this.context;
    }

    public void progress(int progress) {
        this.progress = progress;
    }

    public int progress() {
        return this.progress;
    }

    public void createTime(Date create) {
        this.create = create;
    }

    public Date createTime() {
        return this.create;
    }

    public void updateTime(Date update) {
        this.update = update;
    }

    public Date updateTime() {
        return this.update;
    }

    public void retry() {
        ++this.retries;
    }

    public int retries() {
        return this.retries;
    }

    public void input(String input) {
        this.input = input;
    }

    public String input() {
        return this.input;
    }

    public String result() {
        return this.result;
    }

    private synchronized boolean result(TaskStatus status, String result) {
        this.checkPropertySize(result, "~task_result");
        if (this.status(status)) {
            this.result = result;
            return true;
        }
        return false;
    }

    public void server(Id server) {
        this.server = server;
    }

    public Id server() {
        return this.server;
    }

    public void load(int load) {
        this.load = load;
    }

    public int load() {
        return this.load;
    }

    public boolean completed() {
        return TaskStatus.COMPLETED_STATUSES.contains(this.status);
    }

    public boolean success() {
        return this.status == TaskStatus.SUCCESS;
    }

    public boolean cancelled() {
        return this.status == TaskStatus.CANCELLED || this.isCancelled();
    }

    public boolean cancelling() {
        return this.status == TaskStatus.CANCELLING;
    }

    public boolean computer() {
        return "computer".equals(this.type);
    }

    @Override
    public String toString() {
        return String.format("HugeTask(%s)%s", this.id, this.asMap());
    }

    @Override
    public void run() {
        if (this.cancelled()) {
            return;
        }
        TaskManager.setContext(this.context());
        try {
            assert (this.status.code() < TaskStatus.RUNNING.code()) : this.status;
            if (this.checkDependenciesSuccess()) {
                this.status(TaskStatus.RUNNING);
                super.run();
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
        finally {
            LOG.debug("Task is finished {}", (Object)this);
            TaskManager.resetContext();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (!cancelled) {
            return cancelled;
        }
        try {
            if (this.status(TaskStatus.CANCELLED)) {
                this.callable.cancelled();
            } else {
                cancelled = false;
            }
        }
        catch (Throwable e) {
            LOG.error("An exception occurred when calling cancelled()", e);
        }
        return cancelled;
    }

    public boolean fail(Throwable e) {
        E.checkNotNull((Object)e, (String)"exception");
        if (!this.cancelled() || !HugeException.isInterrupted(e)) {
            LOG.warn("An exception occurred when running task: {}", (Object)this.id(), (Object)e);
            return this.result(TaskStatus.FAILED, e.toString());
        }
        return false;
    }

    public void failToSave(Throwable e) {
        if (!this.fail(e)) {
            this.result = e.toString();
        }
    }

    @Override
    protected void done() {
        try {
            this.callable.done();
        }
        catch (Throwable e) {
            LOG.error("An exception occurred when calling done()", e);
        }
        finally {
            StandardTaskScheduler scheduler = (StandardTaskScheduler)this.scheduler();
            scheduler.taskDone(this);
        }
    }

    @Override
    protected void set(V v) {
        String result = JsonUtil.toJson(v);
        this.checkPropertySize(result, "~task_result");
        if (!this.result(TaskStatus.SUCCESS, result)) assert (this.completed());
        super.set(v);
    }

    @Override
    protected void setException(Throwable e) {
        this.fail(e);
        super.setException(e);
    }

    protected void scheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected TaskScheduler scheduler() {
        E.checkState((this.scheduler != null ? 1 : 0) != 0, (String)"Can't call scheduler() before scheduling task", (Object[])new Object[0]);
        return this.scheduler;
    }

    protected boolean checkDependenciesSuccess() {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return true;
        }
        TaskScheduler scheduler = this.scheduler();
        for (Id dependency : this.dependencies) {
            HugeTask task = scheduler.task(dependency);
            if (!task.completed()) {
                scheduler.schedule(this);
                return false;
            }
            if (task.status() == TaskStatus.CANCELLED) {
                this.result(TaskStatus.CANCELLED, String.format("Cancelled due to dependent task '%s' cancelled", dependency));
                this.done();
                return false;
            }
            if (task.status() != TaskStatus.FAILED) continue;
            this.result(TaskStatus.FAILED, String.format("Failed due to dependent task '%s' failed", dependency));
            this.done();
            return false;
        }
        return true;
    }

    protected TaskCallable<V> callable() {
        E.checkNotNull(this.callable, (String)"callable");
        return this.callable;
    }

    protected synchronized boolean status(TaskStatus status) {
        E.checkNotNull((Object)status, (String)"status");
        if (status.code() > TaskStatus.NEW.code()) {
            E.checkState((this.type != null ? 1 : 0) != 0, (String)"Task type can't be null", (Object[])new Object[0]);
            E.checkState((this.name != null ? 1 : 0) != 0, (String)"Task name can't be null", (Object[])new Object[0]);
        }
        if (!this.completed()) {
            assert (this.status.code() < status.code() || status == TaskStatus.RESTORING) : this.status + " => " + status + " (task " + this.id + ")";
            this.status = status;
            return true;
        }
        return false;
    }

    protected void property(String key, Object value) {
        E.checkNotNull((Object)key, (String)"property key");
        switch (key) {
            case "~task_type": {
                this.type = (String)value;
                break;
            }
            case "~task_name": {
                this.name = (String)value;
                break;
            }
            case "~task_callable": {
                break;
            }
            case "~task_status": {
                this.status = SerialEnum.fromCode(TaskStatus.class, (Byte)value);
                break;
            }
            case "~task_progress": {
                this.progress = (Integer)value;
                break;
            }
            case "~task_create": {
                this.create = (Date)value;
                break;
            }
            case "~task_retries": {
                this.retries = (Integer)value;
                break;
            }
            case "~task_description": {
                this.description = (String)value;
                break;
            }
            case "~task_context": {
                this.context = (String)value;
                break;
            }
            case "~task_update": {
                this.update = (Date)value;
                break;
            }
            case "~task_dependencies": {
                Set values = (Set)value;
                this.dependencies = values.stream().map(IdGenerator::of).collect(HugeTask.toOrderSet());
                break;
            }
            case "~task_input": {
                this.input = StringEncoding.decompress(((Blob)value).bytes(), 10.0f);
                break;
            }
            case "~task_result": {
                this.result = StringEncoding.decompress(((Blob)value).bytes(), 10.0f);
                break;
            }
            case "~task_server": {
                this.server = IdGenerator.of((String)value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
    }

    protected synchronized Object[] asArray() {
        byte[] bytes;
        E.checkState((this.type != null ? 1 : 0) != 0, (String)"Task type can't be null", (Object[])new Object[0]);
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Task name can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(28);
        list.add(T.label);
        list.add(P.TASK);
        list.add(T.id);
        list.add(this.id);
        list.add("~task_type");
        list.add(this.type);
        list.add("~task_name");
        list.add(this.name);
        list.add("~task_callable");
        list.add(this.callable.getClass().getName());
        list.add("~task_status");
        list.add(this.status.code());
        list.add("~task_progress");
        list.add(this.progress);
        list.add("~task_create");
        list.add(this.create);
        list.add("~task_retries");
        list.add(this.retries);
        if (this.description != null) {
            list.add("~task_description");
            list.add(this.description);
        }
        if (this.context != null) {
            list.add("~task_context");
            list.add(this.context);
        }
        if (this.update != null) {
            list.add("~task_update");
            list.add(this.update);
        }
        if (this.dependencies != null) {
            list.add("~task_dependencies");
            list.add(this.dependencies.stream().map(Id::asLong).collect(HugeTask.toOrderSet()));
        }
        if (this.input != null) {
            bytes = StringEncoding.compress(this.input);
            this.checkPropertySize(bytes.length, "~task_input");
            list.add("~task_input");
            list.add(bytes);
        }
        if (this.result != null) {
            bytes = StringEncoding.compress(this.result);
            this.checkPropertySize(bytes.length, "~task_result");
            list.add("~task_result");
            list.add(bytes);
        }
        if (this.server != null) {
            list.add("~task_server");
            list.add(this.server.asString());
        }
        return list.toArray();
    }

    public Map<String, Object> asMap() {
        return this.asMap(true);
    }

    public synchronized Map<String, Object> asMap(boolean withDetails) {
        E.checkState((this.type != null ? 1 : 0) != 0, (String)"Task type can't be null", (Object[])new Object[0]);
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Task name can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)P.ID), this.id);
        map.put(Graph.Hidden.unHide((String)"~task_type"), this.type);
        map.put(Graph.Hidden.unHide((String)"~task_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~task_status"), this.status.string());
        map.put(Graph.Hidden.unHide((String)"~task_progress"), this.progress);
        map.put(Graph.Hidden.unHide((String)"~task_create"), this.create);
        map.put(Graph.Hidden.unHide((String)"~task_retries"), this.retries);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~task_description"), this.description);
        }
        if (this.update != null) {
            map.put(Graph.Hidden.unHide((String)"~task_update"), this.update);
        }
        if (this.dependencies != null) {
            Set<V> value = this.dependencies.stream().map(Id::asLong).collect(HugeTask.toOrderSet());
            map.put(Graph.Hidden.unHide((String)"~task_dependencies"), value);
        }
        if (this.server != null) {
            map.put(Graph.Hidden.unHide((String)"~task_server"), this.server.asString());
        }
        if (withDetails) {
            map.put(Graph.Hidden.unHide((String)"~task_callable"), this.callable.getClass().getName());
            if (this.input != null) {
                map.put(Graph.Hidden.unHide((String)"~task_input"), this.input);
            }
            if (this.result != null) {
                map.put(Graph.Hidden.unHide((String)"~task_result"), this.result);
            }
        }
        return map;
    }

    public static <V> HugeTask<V> fromVertex(Vertex vertex) {
        TaskCallable callable;
        String callableName = (String)vertex.value("~task_callable");
        try {
            callable = TaskCallable.fromClass(callableName);
        }
        catch (Exception e) {
            callable = TaskCallable.empty(e);
        }
        HugeTask task = new HugeTask((Id)vertex.id(), null, callable);
        Iterator iter = vertex.properties(new String[0]);
        while (iter.hasNext()) {
            VertexProperty prop = (VertexProperty)iter.next();
            task.property(prop.key(), prop.value());
        }
        return task;
    }

    private static <V> Collector<V, ?, Set<V>> toOrderSet() {
        return Collectors.toCollection(InsertionOrderUtil::newSet);
    }

    private void checkPropertySize(String property, String propertyName) {
        byte[] bytes = StringEncoding.compress(property);
        this.checkPropertySize(bytes.length, propertyName);
    }

    private void checkPropertySize(int propertyLength, String propertyName) {
        long propertyLimit = 65535L;
        HugeGraph graph = this.scheduler().graph();
        if (propertyName.equals("~task_input")) {
            propertyLimit = (Long)graph.option(CoreOptions.TASK_INPUT_SIZE_LIMIT);
        } else if (propertyName.equals("~task_result")) {
            propertyLimit = (Long)graph.option(CoreOptions.TASK_RESULT_SIZE_LIMIT);
        }
        if ((long)propertyLength > propertyLimit) {
            throw new LimitExceedException("Task %s size %s exceeded limit %s bytes", P.unhide(propertyName), propertyLength, propertyLimit);
        }
    }

    public void syncWait() {
        HugeTask task = null;
        try {
            task = this.scheduler().waitUntilTaskCompleted(this.id());
        }
        catch (Throwable e) {
            if (this.callable() instanceof EphemeralJob && e.getClass() == NotFoundException.class && e.getMessage().contains("Can't find task with id")) {
                return;
            }
            throw new HugeException("Failed to wait for task '%s' completed", e, this.id);
        }
        assert (task != null);
        boolean debugTest = false;
        if (debugTest && !task.success()) {
            throw new HugeException("Task '%s' is failed with error: %s", task.id(), task.result());
        }
    }

    public static final class P {
        public static final String TASK = Graph.Hidden.hide((String)"task");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String TYPE = "~task_type";
        public static final String NAME = "~task_name";
        public static final String CALLABLE = "~task_callable";
        public static final String DESCRIPTION = "~task_description";
        public static final String CONTEXT = "~task_context";
        public static final String STATUS = "~task_status";
        public static final String PROGRESS = "~task_progress";
        public static final String CREATE = "~task_create";
        public static final String UPDATE = "~task_update";
        public static final String RETRIES = "~task_retries";
        public static final String INPUT = "~task_input";
        public static final String RESULT = "~task_result";
        public static final String DEPENDENCIES = "~task_dependencies";
        public static final String SERVER = "~task_server";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"task_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

