/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.type.define;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public interface SerialEnum {
    public static final Table<Class<?>, Byte, SerialEnum> TABLE = HashBasedTable.create();

    public byte code();

    public static void register(Class<? extends SerialEnum> clazz) {
        Object enums;
        try {
            enums = clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        for (SerialEnum e : CollectionUtil.toList((Object)enums)) {
            TABLE.put(clazz, (Object)e.code(), (Object)e);
        }
    }

    public static <T extends SerialEnum> T fromCode(Class<T> clazz, byte code) {
        SerialEnum value = (SerialEnum)TABLE.get(clazz, (Object)code);
        if (value == null) {
            E.checkArgument((boolean)false, (String)"Can't construct %s from code %s", (Object[])new Object[]{clazz.getSimpleName(), code});
        }
        return (T)value;
    }

    public static void registerInternalEnums() {
        SerialEnum.register(Action.class);
        SerialEnum.register(AggregateType.class);
        SerialEnum.register(Cardinality.class);
        SerialEnum.register(DataType.class);
        SerialEnum.register(Directions.class);
        SerialEnum.register(Frequency.class);
        SerialEnum.register(HugeType.class);
        SerialEnum.register(IdStrategy.class);
        SerialEnum.register(IndexType.class);
        SerialEnum.register(SchemaStatus.class);
    }
}

