/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api.composite;

import com.alipay.lookout.api.Clock;
import com.alipay.lookout.api.Counter;
import com.alipay.lookout.api.DistributionSummary;
import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Metric;
import com.alipay.lookout.api.MetricRegistry;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.Timer;
import com.alipay.lookout.api.composite.CompositeCounter;
import com.alipay.lookout.api.composite.CompositeDistributionSummary;
import com.alipay.lookout.api.composite.CompositeMixinMetric;
import com.alipay.lookout.api.composite.CompositeTimer;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.api.info.Info;
import com.alipay.lookout.common.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public final class CompositeRegistry
extends MetricRegistry {
    private final CopyOnWriteArraySet<Registry> registries = new CopyOnWriteArraySet();

    public CompositeRegistry(Clock clock) {
        super(clock);
    }

    @Override
    public void registerExtendedMetrics() {
        for (Registry r : this.registries) {
            if (!(r instanceof MetricRegistry)) continue;
            ((MetricRegistry)r).registerExtendedMetrics();
        }
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public Collection<Registry> getRegistries() {
        return Collections.unmodifiableCollection(this.registries);
    }

    public void add(MetricRegistry registry) {
        Assert.checkArg(!(registry instanceof CompositeRegistry), String.format("registry: %s can not be  a CompositeRegistry!", registry));
        this.registries.add(registry);
    }

    public void remove(Registry registry) {
        this.registries.remove(registry);
    }

    public void clear() {
        this.registries.clear();
    }

    @Override
    public <T extends Number> Gauge<T> gauge(Id id, Gauge<T> gauge) {
        for (Registry r : this.registries) {
            r.gauge(id, gauge);
        }
        return null;
    }

    @Override
    public void removeMetric(Id id) {
        for (Registry r : this.registries) {
            r.removeMetric(id);
        }
    }

    @Override
    public <I, Y extends Info<I>> Info info(Id id, Y info) {
        for (Registry r : this.registries) {
            r.info(id, info);
        }
        return null;
    }

    @Override
    public void register(Metric metric) {
        Assert.checkArg(metric instanceof Gauge, "Only Gauge support now");
        for (Registry r : this.registries) {
            r.register(metric);
        }
    }

    @Override
    public Counter counter(Id id) {
        return new CompositeCounter(id, this.registries);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new CompositeDistributionSummary(id, this.registries);
    }

    @Override
    public Timer timer(Id id) {
        return new CompositeTimer(id, this.clock(), this.registries);
    }

    @Override
    public MixinMetric mixinMetric(Id id) {
        for (Registry registry : this.registries) {
            registry.mixinMetric(id);
        }
        return new CompositeMixinMetric(id, this.clock(), this.registries);
    }

    @Override
    public <X extends Metric> X get(Id id) {
        Object metric;
        Iterator<Registry> iterator = this.registries.iterator();
        Object object = metric = iterator.hasNext() ? (Object)iterator.next().get(id) : null;
        if (metric == null) {
            return null;
        }
        if (MixinMetric.class.isAssignableFrom(metric.getClass())) {
            return (X)new CompositeMixinMetric(id, this.clock(), this.registries);
        }
        if (Gauge.class.isAssignableFrom(metric.getClass())) {
            return (X)metric;
        }
        if (Counter.class.isAssignableFrom(metric.getClass())) {
            return (X)new CompositeCounter(id, this.registries);
        }
        if (Timer.class.isAssignableFrom(metric.getClass())) {
            return (X)new CompositeTimer(id, this.clock(), this.registries);
        }
        if (DistributionSummary.class.isAssignableFrom(metric.getClass())) {
            return (X)new CompositeDistributionSummary(id, this.registries);
        }
        return null;
    }

    @Override
    public Iterator<Metric> iterator() {
        throw new UnsupportedOperationException();
    }
}

