/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import java.util.Map;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.core.storage.azure.AzureLocation;

public class WasbTranslatingFileIO
implements FileIO {
    private final FileIO io;
    private static final String WASB_SCHEME = "wasb";
    private static final String ABFS_SCHEME = "abfs";

    public WasbTranslatingFileIO(FileIO io) {
        this.io = io;
    }

    private static String translate(String path) {
        if (path == null) {
            return null;
        }
        StorageLocation storageLocation = StorageLocation.of((String)path);
        if (storageLocation instanceof AzureLocation) {
            AzureLocation azureLocation = (AzureLocation)storageLocation;
            String scheme = azureLocation.getScheme();
            if (scheme.startsWith(WASB_SCHEME)) {
                scheme = scheme.replaceFirst(WASB_SCHEME, ABFS_SCHEME);
            }
            return String.format("%s://%s@%s.%s/%s", scheme, azureLocation.getContainer(), azureLocation.getStorageAccount(), azureLocation.getEndpoint(), azureLocation.getFilePath());
        }
        return path;
    }

    public InputFile newInputFile(String path) {
        return this.io.newInputFile(WasbTranslatingFileIO.translate(path));
    }

    public OutputFile newOutputFile(String path) {
        return this.io.newOutputFile(WasbTranslatingFileIO.translate(path));
    }

    public void deleteFile(String path) {
        this.io.deleteFile(WasbTranslatingFileIO.translate(path));
    }

    public Map<String, String> properties() {
        return this.io.properties();
    }

    public void initialize(Map<String, String> properties) {
        this.io.initialize(properties);
    }

    public void close() {
        this.io.close();
    }
}

