/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.http;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record IfNoneMatch(boolean isWildcard, @Nonnull List<String> eTags) {
    private static final String WILDCARD_HEADER_VALUE = "*";
    private static final String ETAG_REGEX = "(?:W/)?\"(?:[^\"]*)\"";
    private static final String IF_NONE_MATCH_REGEX = String.format("(?:%s, )*%s", "(?:W/)?\"(?:[^\"]*)\"", "(?:W/)?\"(?:[^\"]*)\"");
    private static final Pattern ETAG_PATTERN = Pattern.compile(String.format("(%s)", "(?:W/)?\"(?:[^\"]*)\""));
    private static final Pattern IF_NONE_MATCH_PATTERN = Pattern.compile(IF_NONE_MATCH_REGEX);
    public static final IfNoneMatch EMPTY = new IfNoneMatch(List.of());
    public static final IfNoneMatch WILDCARD = new IfNoneMatch(true, List.of());

    public IfNoneMatch(List<String> etags) {
        this(false, etags);
    }

    public IfNoneMatch {
        if (isWildcard && !eTags.isEmpty()) {
            throw new IllegalArgumentException("Invalid representation for If-None-Match header. If-None-Match cannot contain ETags if it takes the wildcard value '*'");
        }
        for (String etag : eTags) {
            Matcher matcher = ETAG_PATTERN.matcher(etag);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("Invalid ETag representation: " + etag);
        }
    }

    public static IfNoneMatch fromHeader(String rawValue) {
        if (rawValue == null) {
            return EMPTY;
        }
        if ((rawValue = rawValue.trim()).equals(WILDCARD_HEADER_VALUE)) {
            return WILDCARD;
        }
        if (!IF_NONE_MATCH_PATTERN.matcher(rawValue).matches()) {
            throw new IllegalArgumentException("Invalid If-None-Match header: " + rawValue);
        }
        List<String> etags = ETAG_PATTERN.matcher(rawValue).results().map(MatchResult::group).toList();
        return new IfNoneMatch(etags);
    }

    public boolean anyMatch(String eTag) {
        if (this.isWildcard) {
            return true;
        }
        return this.eTags.contains(eTag);
    }
}

