/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;

public class PolarisBaseEntity
extends PolarisEntityCore {
    public static final String EMPTY_MAP_STRING = "{}";
    protected final int subTypeCode;
    protected final long createTimestamp;
    protected final long dropTimestamp;
    protected final long purgeTimestamp;
    protected final long toPurgeTimestamp;
    protected final long lastUpdateTimestamp;
    protected final String properties;
    protected final String internalProperties;
    protected final int grantRecordsVersion;

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getDropTimestamp() {
        return this.dropTimestamp;
    }

    public long getPurgeTimestamp() {
        return this.purgeTimestamp;
    }

    public long getToPurgeTimestamp() {
        return this.toPurgeTimestamp;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public String getProperties() {
        return this.properties != null ? this.properties : EMPTY_MAP_STRING;
    }

    public PolarisBaseEntity withGrantRecordsVersion(int grantRecordsVersion) {
        return new Builder(this).grantRecordsVersion(grantRecordsVersion).build();
    }

    @JsonIgnore
    public Map<String, String> getPropertiesAsMap() {
        return PolarisObjectMapperUtil.deserializeProperties(this.getProperties());
    }

    @JsonIgnore
    protected static String convertPropertiesToJson(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return EMPTY_MAP_STRING;
        }
        return PolarisObjectMapperUtil.serializeProperties(properties);
    }

    public String getInternalProperties() {
        return this.internalProperties != null ? this.internalProperties : EMPTY_MAP_STRING;
    }

    @JsonIgnore
    public Map<String, String> getInternalPropertiesAsMap() {
        return PolarisObjectMapperUtil.deserializeProperties(this.getInternalProperties());
    }

    public int getGrantRecordsVersion() {
        return this.grantRecordsVersion;
    }

    private PolarisBaseEntity(Builder builder) {
        super(builder);
        this.subTypeCode = builder.subTypeCode;
        this.createTimestamp = builder.createTimestamp == 0L ? System.currentTimeMillis() : builder.createTimestamp;
        this.dropTimestamp = builder.dropTimestamp;
        this.purgeTimestamp = builder.purgeTimestamp;
        this.toPurgeTimestamp = builder.toPurgeTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.properties = builder.properties;
        this.internalProperties = builder.internalProperties;
        this.grantRecordsVersion = builder.grantRecordsVersion == 0 ? 1 : builder.grantRecordsVersion;
    }

    public PolarisBaseEntity(long catalogId, long id, PolarisEntityType type, PolarisEntitySubType subType, long parentId, String name) {
        this(catalogId, id, type.getCode(), subType.getCode(), parentId, name);
    }

    protected PolarisBaseEntity(long catalogId, long id, int typeCode, int subTypeCode, long parentId, String name) {
        super((PolarisEntityCore.Builder<?, ?>)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)new PolarisEntityCore.Builder().catalogId(catalogId)).id(id)).parentId(parentId)).typeCode(typeCode)).name(name)).entityVersion(1));
        this.subTypeCode = subTypeCode;
        this.createTimestamp = System.currentTimeMillis();
        this.dropTimestamp = 0L;
        this.purgeTimestamp = 0L;
        this.toPurgeTimestamp = 0L;
        this.lastUpdateTimestamp = this.createTimestamp;
        this.properties = null;
        this.internalProperties = null;
        this.grantRecordsVersion = 1;
    }

    public PolarisBaseEntity(long catalogId, long id, int typeCode, long parentId, String name, int subTypeCode, long createTimestamp, long dropTimestamp, long purgeTimestamp, long lastUpdateTimestamp, String properties, String internalProperties, int grantRecordsVersion, int entityVersion) {
        super((PolarisEntityCore.Builder<?, ?>)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)new PolarisEntityCore.Builder().catalogId(catalogId)).id(id)).parentId(parentId)).typeCode(typeCode)).name(name)).entityVersion(entityVersion == 0 ? 1 : entityVersion));
        this.subTypeCode = subTypeCode;
        this.createTimestamp = createTimestamp;
        this.dropTimestamp = dropTimestamp;
        this.purgeTimestamp = purgeTimestamp;
        this.toPurgeTimestamp = 0L;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.properties = properties;
        this.internalProperties = internalProperties;
        this.grantRecordsVersion = grantRecordsVersion;
    }

    protected PolarisBaseEntity() {
        super(new Builder());
        this.subTypeCode = 0;
        this.createTimestamp = 0L;
        this.dropTimestamp = 0L;
        this.purgeTimestamp = 0L;
        this.toPurgeTimestamp = 0L;
        this.lastUpdateTimestamp = 0L;
        this.properties = null;
        this.internalProperties = null;
        this.grantRecordsVersion = 0;
    }

    @JsonIgnore
    public PolarisEntitySubType getSubType() {
        return PolarisEntitySubType.fromCode(this.subTypeCode);
    }

    @JsonIgnore
    public boolean isDropped() {
        return this.dropTimestamp != 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolarisBaseEntity)) {
            return false;
        }
        PolarisBaseEntity that = (PolarisBaseEntity)o;
        return this.subTypeCode == that.subTypeCode && this.createTimestamp == that.createTimestamp && this.dropTimestamp == that.dropTimestamp && this.purgeTimestamp == that.purgeTimestamp && this.toPurgeTimestamp == that.toPurgeTimestamp && this.lastUpdateTimestamp == that.lastUpdateTimestamp && this.grantRecordsVersion == that.grantRecordsVersion && Objects.equals(this.properties, that.properties) && Objects.equals(this.internalProperties, that.internalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogId, this.id, this.parentId, this.typeCode, this.name, this.entityVersion, this.subTypeCode, this.createTimestamp, this.dropTimestamp, this.purgeTimestamp, this.toPurgeTimestamp, this.lastUpdateTimestamp, this.properties, this.internalProperties, this.grantRecordsVersion);
    }

    @Override
    public String toString() {
        return "PolarisBaseEntity{" + super.toString() + ", subTypeCode=" + this.subTypeCode + ", createTimestamp=" + this.createTimestamp + ", dropTimestamp=" + this.dropTimestamp + ", purgeTimestamp=" + this.purgeTimestamp + ", toPurgeTimestamp=" + this.toPurgeTimestamp + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + ", grantRecordsVersion=" + this.grantRecordsVersion + "}";
    }

    public static class Builder
    extends PolarisEntityCore.Builder<PolarisBaseEntity, Builder> {
        private int subTypeCode;
        private long createTimestamp;
        private long dropTimestamp;
        private long purgeTimestamp;
        private long toPurgeTimestamp;
        private long lastUpdateTimestamp;
        private String properties;
        private String internalProperties;
        private int grantRecordsVersion;

        public Builder() {
        }

        public Builder subTypeCode(int subTypeCode) {
            this.subTypeCode = subTypeCode;
            return this;
        }

        public Builder createTimestamp(long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return (Builder)this.self();
        }

        public Builder dropTimestamp(long dropTimestamp) {
            this.dropTimestamp = dropTimestamp;
            return (Builder)this.self();
        }

        public Builder purgeTimestamp(long purgeTimestamp) {
            this.purgeTimestamp = purgeTimestamp;
            return (Builder)this.self();
        }

        public Builder toPurgeTimestamp(long toPurgeTimestamp) {
            this.toPurgeTimestamp = toPurgeTimestamp;
            return (Builder)this.self();
        }

        public Builder lastUpdateTimestamp(long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return (Builder)this.self();
        }

        public Builder propertiesAsMap(Map<String, String> properties) {
            this.properties = PolarisBaseEntity.convertPropertiesToJson(properties);
            return (Builder)this.self();
        }

        public Builder properties(String properties) {
            this.properties = properties;
            return (Builder)this.self();
        }

        public Builder internalProperties(String internalProperties) {
            this.internalProperties = internalProperties;
            return (Builder)this.self();
        }

        public Builder internalPropertiesAsMap(Map<String, String> internalProperties) {
            this.internalProperties = PolarisBaseEntity.convertPropertiesToJson(internalProperties);
            return (Builder)this.self();
        }

        public Builder grantRecordsVersion(int grantRecordsVersion) {
            this.grantRecordsVersion = grantRecordsVersion;
            return (Builder)this.self();
        }

        public Builder(PolarisBaseEntity entity) {
            super.catalogId(entity.getCatalogId());
            super.id(entity.getId());
            super.parentId(entity.getParentId());
            super.typeCode(entity.getTypeCode());
            super.name(entity.getName());
            super.entityVersion(entity.getEntityVersion());
            this.subTypeCode = entity.getSubTypeCode();
            this.createTimestamp = entity.getCreateTimestamp();
            this.dropTimestamp = entity.getDropTimestamp();
            this.purgeTimestamp = entity.getPurgeTimestamp();
            this.toPurgeTimestamp = entity.getToPurgeTimestamp();
            this.lastUpdateTimestamp = entity.getLastUpdateTimestamp();
            this.properties = entity.getProperties();
            this.internalProperties = entity.getInternalProperties();
            this.grantRecordsVersion = entity.getGrantRecordsVersion();
        }

        @Override
        public PolarisBaseEntity build() {
            return new PolarisBaseEntity(this);
        }
    }
}

