/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.pagination.Token;
import org.immutables.value.Generated;

@Generated(from="PageToken", generator="Immutables")
public final class ImmutablePageToken
implements PageToken {
    private final Integer pageSize;
    private final Token value;
    private transient int hashCode;

    private ImmutablePageToken(Integer pageSize, Token value) {
        this.pageSize = pageSize;
        this.value = value;
    }

    @Override
    @JsonProperty(value="p")
    public OptionalInt pageSize() {
        return this.pageSize != null ? OptionalInt.of(this.pageSize) : OptionalInt.empty();
    }

    @Override
    @JsonProperty(value="v")
    public Optional<Token> value() {
        return Optional.ofNullable(this.value);
    }

    public final ImmutablePageToken withPageSize(int value) {
        Integer newValue = value;
        if (Objects.equals(this.pageSize, newValue)) {
            return this;
        }
        return new ImmutablePageToken(newValue, this.value);
    }

    public final ImmutablePageToken withPageSize(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.pageSize, value)) {
            return this;
        }
        return new ImmutablePageToken(value, this.value);
    }

    public final ImmutablePageToken withValue(Token value) {
        Token newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return new ImmutablePageToken(this.pageSize, newValue);
    }

    public final ImmutablePageToken withValue(Optional<? extends Token> optional) {
        Token value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return new ImmutablePageToken(this.pageSize, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageToken && this.equalsByValue((ImmutablePageToken)another);
    }

    private boolean equalsByValue(ImmutablePageToken another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.pageSize, another.pageSize) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pageSize);
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PageToken").omitNullValues().add("pageSize", (Object)this.pageSize).add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePageToken fromJson(Json json) {
        Builder builder = ImmutablePageToken.builder();
        if (json._pageSize != null) {
            builder.pageSize(json._pageSize);
        }
        if (json._value != null) {
            builder.value(json._value);
        }
        return builder.build();
    }

    public static ImmutablePageToken copyOf(PageToken instance) {
        if (instance instanceof ImmutablePageToken) {
            return (ImmutablePageToken)instance;
        }
        return ImmutablePageToken.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutablePageToken.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PageToken", generator="Immutables")
    public static final class Builder {
        private Integer pageSize;
        private Token value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PageToken instance) {
            Optional<Token> valueOptional;
            Objects.requireNonNull(instance, "instance");
            OptionalInt pageSizeOptional = instance.pageSize();
            if (pageSizeOptional.isPresent()) {
                this.pageSize(pageSizeOptional);
            }
            if ((valueOptional = instance.value()).isPresent()) {
                this.value(valueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @JsonProperty(value="p")
        @CanIgnoreReturnValue
        public final Builder pageSize(OptionalInt pageSize) {
            this.pageSize = pageSize.isPresent() ? Integer.valueOf(pageSize.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Token value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @JsonProperty(value="v")
        @CanIgnoreReturnValue
        public final Builder value(Optional<? extends Token> value) {
            this.value = value.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.pageSize = null;
            this.value = null;
            return this;
        }

        public ImmutablePageToken build() {
            return new ImmutablePageToken(this.pageSize, this.value);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="PageToken", generator="Immutables")
    static final class Json
    implements PageToken {
        @JsonIgnore
        OptionalInt _pageSize = OptionalInt.empty();
        @JsonIgnore
        Optional<Token> _value = Optional.empty();

        Json() {
        }

        @JsonProperty(value="p")
        public void setPageSize(OptionalInt pageSize) {
            this._pageSize = pageSize;
        }

        @JsonProperty(value="v")
        public void setValue(Optional<Token> value) {
            this._value = value;
        }

        @Override
        public OptionalInt pageSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Token> value() {
            throw new UnsupportedOperationException();
        }
    }
}

