/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import org.apache.iceberg.aws.AwsClientProperties;
import org.apache.iceberg.aws.HttpClientProperties;
import org.apache.iceberg.aws.s3.S3FileIOAwsClientFactory;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;

class DefaultS3FileIOAwsClientFactory
implements S3FileIOAwsClientFactory {
    private S3FileIOProperties s3FileIOProperties = new S3FileIOProperties();
    private HttpClientProperties httpClientProperties = new HttpClientProperties();
    private AwsClientProperties awsClientProperties = new AwsClientProperties();

    DefaultS3FileIOAwsClientFactory() {
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.s3FileIOProperties = new S3FileIOProperties(properties);
        this.awsClientProperties = new AwsClientProperties(properties);
        this.httpClientProperties = new HttpClientProperties(properties);
    }

    @Override
    public S3Client s3() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyServiceConfigurations)).applyMutation(s3ClientBuilder -> this.s3FileIOProperties.applyCredentialConfigurations(this.awsClientProperties, s3ClientBuilder))).applyMutation(this.s3FileIOProperties::applySignerConfiguration)).applyMutation(this.s3FileIOProperties::applyS3AccessGrantsConfigurations)).applyMutation(this.s3FileIOProperties::applyUserAgentConfigurations)).applyMutation(this.s3FileIOProperties::applyRetryConfigurations)).build();
    }

    @Override
    public S3AsyncClient s3Async() {
        if (this.s3FileIOProperties.isS3CRTEnabled()) {
            return ((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)S3AsyncClient.crtBuilder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.awsClientProperties::applyClientCredentialConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyS3CrtConfigurations)).build();
        }
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.awsClientProperties::applyClientCredentialConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).build();
    }
}

