/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.Enablement;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.api.Spi;
import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.apiimpl.BasicCircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.apiimpl.BuilderEagerDependencies;
import io.smallrye.faulttolerance.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.apiimpl.FaultToleranceImpl;
import io.smallrye.faulttolerance.apiimpl.GuardImpl;
import io.smallrye.faulttolerance.apiimpl.TypedGuardImpl;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class CdiSpi
implements Spi {
    private BuilderEagerDependencies eagerDependencies() {
        return (BuilderEagerDependencies)CDI.current().select(EagerDependencies.class, new Annotation[0]).get();
    }

    private BuilderLazyDependencies lazyDependencies() {
        return (BuilderLazyDependencies)CDI.current().select(LazyDependencies.class, new Annotation[0]).get();
    }

    public boolean applies() {
        try {
            CDI.current();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public int priority() {
        return 1000;
    }

    public Guard.Builder newGuardBuilder() {
        return new GuardImpl.BuilderImpl(this.eagerDependencies(), this::lazyDependencies);
    }

    public <T> TypedGuard.Builder<T> newTypedGuardBuilder(Type type) {
        return new TypedGuardImpl.BuilderImpl(this.eagerDependencies(), this::lazyDependencies, type);
    }

    @Deprecated(forRemoval=true)
    public <T, R> FaultTolerance.Builder<T, R> newBuilder(Function<FaultTolerance<T>, R> finisher) {
        return new FaultToleranceImpl.BuilderImpl(this.eagerDependencies(), this::lazyDependencies, null, finisher);
    }

    @Deprecated(forRemoval=true)
    public <T, R> FaultTolerance.Builder<T, R> newAsyncBuilder(Class<?> asyncType, Function<FaultTolerance<T>, R> finisher) {
        return new FaultToleranceImpl.BuilderImpl(this.eagerDependencies(), this::lazyDependencies, asyncType, finisher);
    }

    public CircuitBreakerMaintenance circuitBreakerMaintenance() {
        return this.eagerDependencies().cbMaintenance();
    }

    @Singleton
    public static class EagerDependencies
    implements BuilderEagerDependencies {
        @Inject
        CircuitBreakerMaintenanceImpl cbMaintenance;

        public BasicCircuitBreakerMaintenanceImpl cbMaintenance() {
            return this.cbMaintenance;
        }
    }

    @Singleton
    public static class LazyDependencies
    implements BuilderLazyDependencies {
        @Inject
        Enablement enablement;
        @Inject
        ExecutorHolder executorHolder;
        @Inject
        MetricsProvider metricsProvider;

        public boolean ftEnabled() {
            return this.enablement.ft();
        }

        public ExecutorService asyncExecutor() {
            return this.executorHolder.getAsyncExecutor();
        }

        public EventLoop eventLoop() {
            return this.executorHolder.getEventLoop();
        }

        public Timer timer() {
            return this.executorHolder.getTimer();
        }

        public MetricsProvider metricsProvider() {
            return this.metricsProvider;
        }
    }
}

