/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.timeout.FutureTimeoutNotification;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutLogger;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.Executor;

public class FutureTimeout<V>
implements FaultToleranceStrategy<java.util.concurrent.Future<V>> {
    private final FaultToleranceStrategy<java.util.concurrent.Future<V>> delegate;
    private final Executor executor;

    public FutureTimeout(Timeout<java.util.concurrent.Future<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<java.util.concurrent.Future<V>> apply(FaultToleranceContext<java.util.concurrent.Future<V>> ctx) {
        TimeoutLogger.LOG.trace("FutureTimeout started");
        try {
            Completer completer = Completer.create();
            ctx.set(FutureTimeoutNotification.class, completer::completeWithError);
            this.executor.execute(() -> {
                try {
                    completer.complete(this.delegate.apply(ctx).awaitBlocking());
                }
                catch (Throwable e) {
                    completer.completeWithError(e);
                }
            });
            Future<java.util.concurrent.Future<V>> future = completer.future();
            return future;
        }
        finally {
            TimeoutLogger.LOG.trace("FutureTimeout finished");
        }
    }
}

