/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements DirectCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLRecord>,
XMLMapping,
XMLNillableMapping {
    private boolean isCDATA;
    private boolean isDefaultEmptyContainer = true;
    private boolean isWriteOnly;
    private AbstractNullPolicy nullPolicy = new NullPolicy();
    protected boolean reuseContainer;
    private boolean isCollapsingStringValues;
    private boolean isNormalizingStringValues;
    private AbstractNullPolicy wrapperNullPolicy;
    protected transient Object nullValue;

    public XMLCompositeDirectCollectionMapping() {
        this.nullPolicy.setNullRepresentedByEmptyNode(true);
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        super.initialize(session);
        if (this.getField() instanceof XMLField) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                TypeConversionConverter converter = (TypeConversionConverter)this.valueConverter;
                this.getField().setType(converter.getObjectClass());
            }
            String xpathString = ((XMLField)this.getField()).getXPath();
            if (this.isAbstractCompositeDirectCollectionMapping() && xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
                throw DescriptorException.invalidXpathForXMLDirectMapping(this);
            }
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    @Override
    public void setXPath(String xpathString) {
        if (((String)xpathString).indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !((String)xpathString).endsWith("text()")) {
            xpathString = (String)xpathString + "/text()";
        }
        this.setField(new XMLField((String)xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        DOMRecord domRecord = (DOMRecord)row;
        Object fieldValue = domRecord.getValues(this.getField(), this.getNullPolicy());
        if (fieldValue == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            result = container != null ? container : cp.containerInstance();
        } else {
            result = cp.containerInstance(fieldValues.size());
        }
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if ((element = this.convertDataValueToObjectValue(element, executionSession, ((XMLRecord)row).getUnmarshaller())) != null && element.getClass() == ClassConstants.STRING) {
                if (this.isCollapsingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().collapseStringValue((String)element);
                } else if (this.isNormalizingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().normalizeStringValue((String)element);
                }
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        if (null != iter) {
            while (cp.hasNext(iter)) {
                Object element = cp.next(iter, session);
                if ((element = this.convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller())) != null) {
                    elements.addElement(element);
                    continue;
                }
                if (this.usesSingleNode()) continue;
                AbstractNullPolicy nullPolicy = this.getNullPolicy();
                if (nullPolicy == null) {
                    elements.addElement(null);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    elements.addElement(XMLRecord.NIL);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.ABSENT_NODE) continue;
                elements.addElement("");
            }
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = this.convertObjectValueToDataValue(value, session, record.getMarshaller());
        record.add(this.getField(), element);
    }

    @Override
    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    @Override
    public boolean isCDATA() {
        return this.isCDATA;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    @Override
    public void setNullPolicy(AbstractNullPolicy value) {
        this.nullPolicy = value;
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public boolean isNormalizingStringValues() {
        return this.isNormalizingStringValues;
    }

    @Override
    public void setNormalizingStringValues(boolean normalize) {
        this.isNormalizingStringValues = normalize;
    }

    @Override
    public void setCollapsingStringValues(boolean collapse) {
        this.isCollapsingStringValues = collapse;
    }

    @Override
    public boolean isCollapsingStringValues() {
        return this.isCollapsingStringValues;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.isDefaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.isDefaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value, Session session, XMLMarshaller marshaller) {
        if (this.hasValueConverter()) {
            if (this.valueConverter instanceof XMLConverter) {
                return ((XMLConverter)this.valueConverter).convertObjectValueToDataValue(value, session, marshaller);
            }
            return this.valueConverter.convertObjectValueToDataValue(value, session);
        }
        return value;
    }

    @Override
    public Object convertDataValueToObjectValue(Object value, Session session, XMLUnmarshaller unmarshaller) {
        if (this.hasValueConverter()) {
            if (this.valueConverter instanceof XMLConverter) {
                return ((XMLConverter)this.valueConverter).convertDataValueToObjectValue(value, session, unmarshaller);
            }
            return this.valueConverter.convertDataValueToObjectValue(value, session);
        }
        return value;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }
}

