/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.immutables.value.Generated;

@Generated(from="AwsStorageConfigurationInfo", generator="Immutables")
public final class ImmutableAwsStorageConfigurationInfo
extends AwsStorageConfigurationInfo {
    private final ImmutableList<String> allowedLocations;
    @Nullable
    private final String roleARN;
    @Nullable
    private final String externalId;
    @Nullable
    private final String userARN;
    @Nullable
    private final String region;
    @Nullable
    private final String endpoint;
    @Nullable
    private final String endpointInternal;
    @Nullable
    private final Boolean pathStyleAccess;
    @Nullable
    private final String stsEndpoint;
    private transient int hashCode;

    private ImmutableAwsStorageConfigurationInfo(ImmutableList<String> allowedLocations, @Nullable String roleARN, @Nullable String externalId, @Nullable String userARN, @Nullable String region, @Nullable String endpoint, @Nullable String endpointInternal, @Nullable Boolean pathStyleAccess, @Nullable String stsEndpoint) {
        this.allowedLocations = allowedLocations;
        this.roleARN = roleARN;
        this.externalId = externalId;
        this.userARN = userARN;
        this.region = region;
        this.endpoint = endpoint;
        this.endpointInternal = endpointInternal;
        this.pathStyleAccess = pathStyleAccess;
        this.stsEndpoint = stsEndpoint;
    }

    @JsonProperty
    public ImmutableList<String> getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getRoleARN() {
        return this.roleARN;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getUserARN() {
        return this.userARN;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getRegion() {
        return this.region;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getEndpointInternal() {
        return this.endpointInternal;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean getPathStyleAccess() {
        return this.pathStyleAccess;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    public final ImmutableAwsStorageConfigurationInfo withAllowedLocations(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo((ImmutableList<String>)newValue, this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withAllowedLocations(Iterable<String> elements) {
        if (this.allowedLocations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo((ImmutableList<String>)newValue, this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withRoleARN(@Nullable String value) {
        if (Objects.equals(this.roleARN, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, value, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withExternalId(@Nullable String value) {
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, value, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withUserARN(@Nullable String value) {
        if (Objects.equals(this.userARN, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, value, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withRegion(@Nullable String value) {
        if (Objects.equals(this.region, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, this.userARN, value, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withEndpoint(@Nullable String value) {
        if (Objects.equals(this.endpoint, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, this.userARN, this.region, value, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withEndpointInternal(@Nullable String value) {
        if (Objects.equals(this.endpointInternal, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, value, this.pathStyleAccess, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withPathStyleAccess(@Nullable Boolean value) {
        if (Objects.equals(this.pathStyleAccess, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, value, this.stsEndpoint));
    }

    public final ImmutableAwsStorageConfigurationInfo withStsEndpoint(@Nullable String value) {
        if (Objects.equals(this.stsEndpoint, value)) {
            return this;
        }
        return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo(this.allowedLocations, this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAwsStorageConfigurationInfo && this.equalsByValue((ImmutableAwsStorageConfigurationInfo)another);
    }

    private boolean equalsByValue(ImmutableAwsStorageConfigurationInfo another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.allowedLocations.equals(another.allowedLocations) && Objects.equals(this.roleARN, another.roleARN) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.userARN, another.userARN) && Objects.equals(this.region, another.region) && Objects.equals(this.endpoint, another.endpoint) && Objects.equals(this.endpointInternal, another.endpointInternal) && Objects.equals(this.pathStyleAccess, another.pathStyleAccess) && Objects.equals(this.stsEndpoint, another.stsEndpoint);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.allowedLocations.hashCode();
        h += (h << 5) + Objects.hashCode(this.roleARN);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.userARN);
        h += (h << 5) + Objects.hashCode(this.region);
        h += (h << 5) + Objects.hashCode(this.endpoint);
        h += (h << 5) + Objects.hashCode(this.endpointInternal);
        h += (h << 5) + Objects.hashCode(this.pathStyleAccess);
        h += (h << 5) + Objects.hashCode(this.stsEndpoint);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AwsStorageConfigurationInfo").omitNullValues().add("allowedLocations", this.allowedLocations).add("roleARN", (Object)this.roleARN).add("externalId", (Object)this.externalId).add("userARN", (Object)this.userARN).add("region", (Object)this.region).add("endpoint", (Object)this.endpoint).add("endpointInternal", (Object)this.endpointInternal).add("pathStyleAccess", (Object)this.pathStyleAccess).add("stsEndpoint", (Object)this.stsEndpoint).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAwsStorageConfigurationInfo fromJson(Json json) {
        Builder builder = ImmutableAwsStorageConfigurationInfo.builder();
        if (json._allowedLocations != null) {
            builder.addAllAllowedLocations(json._allowedLocations);
        }
        if (json._roleARN != null) {
            builder.roleARN(json._roleARN);
        }
        if (json._externalId != null) {
            builder.externalId(json._externalId);
        }
        if (json._userARN != null) {
            builder.userARN(json._userARN);
        }
        if (json._region != null) {
            builder.region(json._region);
        }
        if (json._endpoint != null) {
            builder.endpoint(json._endpoint);
        }
        if (json._endpointInternal != null) {
            builder.endpointInternal(json._endpointInternal);
        }
        if (json._pathStyleAccess != null) {
            builder.pathStyleAccess(json._pathStyleAccess);
        }
        if (json._stsEndpoint != null) {
            builder.stsEndpoint(json._stsEndpoint);
        }
        return builder.build();
    }

    private static ImmutableAwsStorageConfigurationInfo validate(ImmutableAwsStorageConfigurationInfo instance) {
        instance.check();
        return instance;
    }

    public static ImmutableAwsStorageConfigurationInfo copyOf(AwsStorageConfigurationInfo instance) {
        if (instance instanceof ImmutableAwsStorageConfigurationInfo) {
            return (ImmutableAwsStorageConfigurationInfo)instance;
        }
        return ImmutableAwsStorageConfigurationInfo.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAwsStorageConfigurationInfo.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AwsStorageConfigurationInfo", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> allowedLocations = ImmutableList.builder();
        private String roleARN;
        private String externalId;
        private String userARN;
        private String region;
        private String endpoint;
        private String endpointInternal;
        private Boolean pathStyleAccess;
        private String stsEndpoint;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AwsStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            PolarisStorageConfigurationInfo instance;
            long bits = 0L;
            if (object instanceof AwsStorageConfigurationInfo) {
                String regionValue;
                String endpointInternalValue;
                String externalIdValue;
                Boolean pathStyleAccessValue;
                String userARNValue;
                String roleARNValue;
                String stsEndpointValue;
                instance = (AwsStorageConfigurationInfo)object;
                String endpointValue = ((AwsStorageConfigurationInfo)instance).getEndpoint();
                if (endpointValue != null) {
                    this.endpoint(endpointValue);
                }
                if ((stsEndpointValue = ((AwsStorageConfigurationInfo)instance).getStsEndpoint()) != null) {
                    this.stsEndpoint(stsEndpointValue);
                }
                if ((roleARNValue = ((AwsStorageConfigurationInfo)instance).getRoleARN()) != null) {
                    this.roleARN(roleARNValue);
                }
                if ((userARNValue = ((AwsStorageConfigurationInfo)instance).getUserARN()) != null) {
                    this.userARN(userARNValue);
                }
                if ((pathStyleAccessValue = ((AwsStorageConfigurationInfo)instance).getPathStyleAccess()) != null) {
                    this.pathStyleAccess(pathStyleAccessValue);
                }
                if ((externalIdValue = ((AwsStorageConfigurationInfo)instance).getExternalId()) != null) {
                    this.externalId(externalIdValue);
                }
                if ((endpointInternalValue = ((AwsStorageConfigurationInfo)instance).getEndpointInternal()) != null) {
                    this.endpointInternal(endpointInternalValue);
                }
                if ((regionValue = ((AwsStorageConfigurationInfo)instance).getRegion()) != null) {
                    this.region(regionValue);
                }
            }
            if (object instanceof PolarisStorageConfigurationInfo) {
                instance = (PolarisStorageConfigurationInfo)object;
                this.addAllAllowedLocations(instance.getAllowedLocations());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocation(String element) {
            this.allowedLocations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocations(String ... elements) {
            this.allowedLocations.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowedLocations(Iterable<String> elements) {
            this.allowedLocations = ImmutableList.builder();
            return this.addAllAllowedLocations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllowedLocations(Iterable<String> elements) {
            this.allowedLocations.addAll(elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder roleARN(@Nullable String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder externalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder userARN(@Nullable String userARN) {
            this.userARN = userARN;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder region(@Nullable String region) {
            this.region = region;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder endpoint(@Nullable String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder endpointInternal(@Nullable String endpointInternal) {
            this.endpointInternal = endpointInternal;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pathStyleAccess(@Nullable Boolean pathStyleAccess) {
            this.pathStyleAccess = pathStyleAccess;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder stsEndpoint(@Nullable String stsEndpoint) {
            this.stsEndpoint = stsEndpoint;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.allowedLocations = ImmutableList.builder();
            this.roleARN = null;
            this.externalId = null;
            this.userARN = null;
            this.region = null;
            this.endpoint = null;
            this.endpointInternal = null;
            this.pathStyleAccess = null;
            this.stsEndpoint = null;
            return this;
        }

        public ImmutableAwsStorageConfigurationInfo build() {
            return ImmutableAwsStorageConfigurationInfo.validate(new ImmutableAwsStorageConfigurationInfo((ImmutableList<String>)this.allowedLocations.build(), this.roleARN, this.externalId, this.userARN, this.region, this.endpoint, this.endpointInternal, this.pathStyleAccess, this.stsEndpoint));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="AwsStorageConfigurationInfo", generator="Immutables")
    static final class Json
    extends AwsStorageConfigurationInfo {
        @JsonIgnore
        List<String> _allowedLocations = ImmutableList.of();
        @JsonIgnore
        String _roleARN;
        @JsonIgnore
        String _externalId;
        @JsonIgnore
        String _userARN;
        @JsonIgnore
        String _region;
        @JsonIgnore
        String _endpoint;
        @JsonIgnore
        String _endpointInternal;
        @JsonIgnore
        Boolean _pathStyleAccess;
        @JsonIgnore
        String _stsEndpoint;

        Json() {
        }

        @JsonProperty
        public void setAllowedLocations(List<String> allowedLocations) {
            this._allowedLocations = allowedLocations;
        }

        @JsonProperty
        public void setRoleARN(@Nullable String roleARN) {
            this._roleARN = roleARN;
        }

        @JsonProperty
        public void setExternalId(@Nullable String externalId) {
            this._externalId = externalId;
        }

        @JsonProperty
        public void setUserARN(@Nullable String userARN) {
            this._userARN = userARN;
        }

        @JsonProperty
        public void setRegion(@Nullable String region) {
            this._region = region;
        }

        @JsonProperty
        public void setEndpoint(@Nullable String endpoint) {
            this._endpoint = endpoint;
        }

        @JsonProperty
        public void setEndpointInternal(@Nullable String endpointInternal) {
            this._endpointInternal = endpointInternal;
        }

        @JsonProperty
        public void setPathStyleAccess(@Nullable Boolean pathStyleAccess) {
            this._pathStyleAccess = pathStyleAccess;
        }

        @JsonProperty
        public void setStsEndpoint(@Nullable String stsEndpoint) {
            this._stsEndpoint = stsEndpoint;
        }

        @Override
        public List<String> getAllowedLocations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRoleARN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserARN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRegion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEndpointInternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getPathStyleAccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStsEndpoint() {
            throw new UnsupportedOperationException();
        }
    }
}

