/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.gcp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;
import org.immutables.value.Generated;

@Generated(from="GcpStorageConfigurationInfo", generator="Immutables")
public final class ImmutableGcpStorageConfigurationInfo
extends GcpStorageConfigurationInfo {
    private final ImmutableList<String> allowedLocations;
    @Nullable
    private final String gcpServiceAccount;
    private transient int hashCode;

    private ImmutableGcpStorageConfigurationInfo(ImmutableList<String> allowedLocations, @Nullable String gcpServiceAccount) {
        this.allowedLocations = allowedLocations;
        this.gcpServiceAccount = gcpServiceAccount;
    }

    @JsonProperty
    public ImmutableList<String> getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getGcpServiceAccount() {
        return this.gcpServiceAccount;
    }

    public final ImmutableGcpStorageConfigurationInfo withAllowedLocations(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableGcpStorageConfigurationInfo.validate(new ImmutableGcpStorageConfigurationInfo((ImmutableList<String>)newValue, this.gcpServiceAccount));
    }

    public final ImmutableGcpStorageConfigurationInfo withAllowedLocations(Iterable<String> elements) {
        if (this.allowedLocations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableGcpStorageConfigurationInfo.validate(new ImmutableGcpStorageConfigurationInfo((ImmutableList<String>)newValue, this.gcpServiceAccount));
    }

    public final ImmutableGcpStorageConfigurationInfo withGcpServiceAccount(@Nullable String value) {
        if (Objects.equals(this.gcpServiceAccount, value)) {
            return this;
        }
        return ImmutableGcpStorageConfigurationInfo.validate(new ImmutableGcpStorageConfigurationInfo(this.allowedLocations, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGcpStorageConfigurationInfo && this.equalsByValue((ImmutableGcpStorageConfigurationInfo)another);
    }

    private boolean equalsByValue(ImmutableGcpStorageConfigurationInfo another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.allowedLocations.equals(another.allowedLocations) && Objects.equals(this.gcpServiceAccount, another.gcpServiceAccount);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.allowedLocations.hashCode();
        h += (h << 5) + Objects.hashCode(this.gcpServiceAccount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GcpStorageConfigurationInfo").omitNullValues().add("allowedLocations", this.allowedLocations).add("gcpServiceAccount", (Object)this.gcpServiceAccount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGcpStorageConfigurationInfo fromJson(Json json) {
        Builder builder = ImmutableGcpStorageConfigurationInfo.builder();
        if (json._allowedLocations != null) {
            builder.addAllAllowedLocations(json._allowedLocations);
        }
        if (json._gcpServiceAccount != null) {
            builder.gcpServiceAccount(json._gcpServiceAccount);
        }
        return builder.build();
    }

    private static ImmutableGcpStorageConfigurationInfo validate(ImmutableGcpStorageConfigurationInfo instance) {
        instance.check();
        return instance;
    }

    public static ImmutableGcpStorageConfigurationInfo copyOf(GcpStorageConfigurationInfo instance) {
        if (instance instanceof ImmutableGcpStorageConfigurationInfo) {
            return (ImmutableGcpStorageConfigurationInfo)instance;
        }
        return ImmutableGcpStorageConfigurationInfo.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableGcpStorageConfigurationInfo.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GcpStorageConfigurationInfo", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> allowedLocations = ImmutableList.builder();
        private String gcpServiceAccount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GcpStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String gcpServiceAccountValue;
            PolarisStorageConfigurationInfo instance;
            long bits = 0L;
            if (object instanceof PolarisStorageConfigurationInfo) {
                instance = (PolarisStorageConfigurationInfo)object;
                this.addAllAllowedLocations(instance.getAllowedLocations());
            }
            if (object instanceof GcpStorageConfigurationInfo && (gcpServiceAccountValue = ((GcpStorageConfigurationInfo)(instance = (GcpStorageConfigurationInfo)object)).getGcpServiceAccount()) != null) {
                this.gcpServiceAccount(gcpServiceAccountValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocation(String element) {
            this.allowedLocations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocations(String ... elements) {
            this.allowedLocations.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowedLocations(Iterable<String> elements) {
            this.allowedLocations = ImmutableList.builder();
            return this.addAllAllowedLocations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllowedLocations(Iterable<String> elements) {
            this.allowedLocations.addAll(elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder gcpServiceAccount(@Nullable String gcpServiceAccount) {
            this.gcpServiceAccount = gcpServiceAccount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.allowedLocations = ImmutableList.builder();
            this.gcpServiceAccount = null;
            return this;
        }

        public ImmutableGcpStorageConfigurationInfo build() {
            return ImmutableGcpStorageConfigurationInfo.validate(new ImmutableGcpStorageConfigurationInfo((ImmutableList<String>)this.allowedLocations.build(), this.gcpServiceAccount));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="GcpStorageConfigurationInfo", generator="Immutables")
    static final class Json
    extends GcpStorageConfigurationInfo {
        @JsonIgnore
        List<String> _allowedLocations = ImmutableList.of();
        @JsonIgnore
        String _gcpServiceAccount;

        Json() {
        }

        @JsonProperty
        public void setAllowedLocations(List<String> allowedLocations) {
            this._allowedLocations = allowedLocations;
        }

        @JsonProperty
        public void setGcpServiceAccount(@Nullable String gcpServiceAccount) {
            this._gcpServiceAccount = gcpServiceAccount;
        }

        @Override
        public List<String> getAllowedLocations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGcpServiceAccount() {
            throw new UnsupportedOperationException();
        }
    }
}

