/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.auth.OAuthTokenErrorResponse;
import org.apache.polaris.service.auth.OAuthUtils;
import org.apache.polaris.service.auth.TokenBroker;
import org.apache.polaris.service.auth.TokenResponse;
import org.apache.polaris.service.catalog.api.IcebergRestOAuth2ApiService;
import org.apache.polaris.service.types.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultOAuth2ApiService
implements IcebergRestOAuth2ApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2ApiService.class);
    private static final String BEARER = "bearer";
    private final TokenBroker tokenBroker;
    private final CallContext callContext;

    @Inject
    public DefaultOAuth2ApiService(TokenBroker tokenBroker, CallContext callContext) {
        this.tokenBroker = tokenBroker;
        this.callContext = callContext;
    }

    public Response getToken(String authHeader, String grantType, String scope, String clientId, String clientSecret, TokenType requestedTokenType, String subjectToken, TokenType subjectTokenType, String actorToken, TokenType actorTokenType, RealmContext realmContext, SecurityContext securityContext) {
        TokenResponse tokenResponse;
        if (!this.tokenBroker.supportsGrantType(grantType)) {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.unsupported_grant_type);
        }
        if (!this.tokenBroker.supportsRequestedTokenType(requestedTokenType)) {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.invalid_request);
        }
        if (authHeader == null && clientSecret == null) {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.invalid_client);
        }
        if (authHeader != null && clientSecret == null && authHeader.startsWith("Basic ")) {
            String credentials = new String(Base64.getDecoder().decode(authHeader.substring(6).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            if (!credentials.contains(":")) {
                return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.invalid_request);
            }
            LOGGER.debug("Found credentials in auth header - treating as client_credentials");
            String[] parts = credentials.split(":", 2);
            if (parts.length == 2) {
                clientId = parts[0];
                clientSecret = parts[1];
            } else {
                LOGGER.debug("Don't know how to parse Basic auth header");
                return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.invalid_request);
            }
        }
        if (clientSecret != null) {
            tokenResponse = this.tokenBroker.generateFromClientSecrets(clientId, clientSecret, grantType, scope, this.callContext.getPolarisCallContext(), requestedTokenType);
        } else if (subjectToken != null) {
            tokenResponse = this.tokenBroker.generateFromToken(subjectTokenType, subjectToken, grantType, scope, this.callContext.getPolarisCallContext(), requestedTokenType);
        } else {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.invalid_request);
        }
        if (tokenResponse == null) {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)OAuthTokenErrorResponse.Error.unsupported_grant_type);
        }
        if (!tokenResponse.isValid()) {
            return OAuthUtils.getResponseFromError((OAuthTokenErrorResponse.Error)tokenResponse.getError());
        }
        return Response.ok((Object)OAuthTokenResponse.builder().withToken(tokenResponse.getAccessToken()).withTokenType(BEARER).withIssuedTokenType(tokenResponse.getTokenType()).setExpirationInSeconds(tokenResponse.getExpiresIn()).build()).build();
    }

    public DefaultOAuth2ApiService() {
    }
}

