/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.polaris.core.persistence.EntityAlreadyExistsException;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.QueryGenerator;
import org.apache.polaris.persistence.relational.jdbc.RelationalJdbcConfiguration;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasourceOperations.class);
    private static final String CONSTRAINT_VIOLATION_SQL_CODE = "23505";
    private static final String SERIALIZATION_FAILURE_SQL_CODE = "40001";
    private final DataSource datasource;
    private final RelationalJdbcConfiguration relationalJdbcConfiguration;
    private final DatabaseType databaseType;
    private final Random random = new Random();

    public DatasourceOperations(DataSource datasource, RelationalJdbcConfiguration relationalJdbcConfiguration) throws SQLException {
        this.datasource = datasource;
        this.relationalJdbcConfiguration = relationalJdbcConfiguration;
        try (Connection connection = this.datasource.getConnection();){
            String productName = connection.getMetaData().getDatabaseProductName();
            this.databaseType = DatabaseType.fromDisplayName(productName);
        }
    }

    DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void executeScript(InputStream scriptInputStream) throws SQLException {
        try (BufferedReader scriptReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(scriptInputStream), StandardCharsets.UTF_8));){
            List<String> scriptLines = scriptReader.lines().toList();
            this.runWithinTransaction(connection -> {
                try (Statement statement = connection.createStatement();){
                    StringBuilder sqlBuffer = new StringBuilder();
                    for (String line : scriptLines) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("--")) continue;
                        sqlBuffer.append(line).append("\n");
                        if (!line.endsWith(";")) continue;
                        String sql = sqlBuffer.toString().trim();
                        try {
                            statement.execute(sql);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                        sqlBuffer.setLength(0);
                    }
                    boolean bl = true;
                    return bl;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> executeSelect(@Nonnull QueryGenerator.PreparedQuery query, @Nonnull Converter<T> converterInstance) throws SQLException {
        ArrayList results = new ArrayList();
        this.executeSelectOverStream(query, converterInstance, stream -> stream.forEach(results::add));
        return results;
    }

    public <T> void executeSelectOverStream(@Nonnull QueryGenerator.PreparedQuery query, @Nonnull Converter<T> converterInstance, @Nonnull Consumer<Stream<T>> consumer) throws SQLException {
        this.withRetries(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public int executeUpdate(QueryGenerator.PreparedQuery preparedQuery) throws SQLException {
        return this.withRetries(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public void runWithinTransaction(TransactionCallback callback) throws SQLException {
        this.withRetries(() -> {
            try (Connection connection = this.borrowConnection();){
                boolean autoCommit = connection.getAutoCommit();
                boolean success = false;
                connection.setAutoCommit(false);
                try {
                    try {
                        success = callback.execute(connection);
                    }
                    finally {
                        if (success) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                    }
                }
                finally {
                    connection.setAutoCommit(autoCommit);
                }
            }
            return null;
        });
    }

    public Integer execute(Connection connection, QueryGenerator.PreparedQuery preparedQuery) throws SQLException {
        DatasourceOperations.logQuery(preparedQuery);
        try (PreparedStatement statement = connection.prepareStatement(preparedQuery.sql());){
            List<Object> params = preparedQuery.parameters();
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
            Integer n = statement.executeUpdate();
            return n;
        }
    }

    private boolean isRetryable(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            return sqlState.equals(SERIALIZATION_FAILURE_SQL_CODE);
        }
        return e.getMessage().toLowerCase(Locale.ROOT).contains("connection refused") || e.getMessage().toLowerCase(Locale.ROOT).contains("connection reset");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    <T> T withRetries(Operation<T> operation) throws SQLException {
        int attempts = 0;
        int maxAttempts = this.relationalJdbcConfiguration.maxRetries().orElse(1);
        long maxDuration = this.relationalJdbcConfiguration.maxDurationInMs().orElse(5000L);
        long delay = this.relationalJdbcConfiguration.initialDelayInMs().orElse(100L);
        long maxRetryTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + maxDuration;
        while (attempts < maxAttempts) {
            try {
                return operation.execute();
            }
            catch (RuntimeException | SQLException e) {
                SQLException sqlException;
                if (e instanceof RuntimeException) {
                    if (!(e.getCause() instanceof SQLException) || e instanceof EntityAlreadyExistsException) throw e;
                    sqlException = (SQLException)e.getCause();
                } else {
                    sqlException = (SQLException)e;
                }
                long timeLeft = Math.max(maxRetryTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()), 0L);
                if (timeLeft == 0L || ++attempts >= maxAttempts || !this.isRetryable(sqlException)) {
                    String exceptionMessage = String.format("Failed due to '%s' (error code %d, sql-state '%s'), after %s attempts and %s milliseconds", sqlException.getMessage(), sqlException.getErrorCode(), sqlException.getSQLState(), attempts, maxDuration);
                    throw new SQLException(exceptionMessage, sqlException.getSQLState(), sqlException.getErrorCode(), e);
                }
                long timeToSleep = Math.min(timeLeft, delay + (long)((double)this.random.nextFloat() * 0.2 * (double)delay));
                LOGGER.debug("Sleeping {} ms before retrying {} on attempt {} / {}, reason {}", new Object[]{timeToSleep, operation, attempts, maxAttempts, e.getMessage(), e});
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", ie);
                }
                delay *= 2L;
            }
        }
        return null;
    }

    public boolean isConstraintViolation(SQLException e) {
        return CONSTRAINT_VIOLATION_SQL_CODE.equals(e.getSQLState());
    }

    private Connection borrowConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    private static void logQuery(QueryGenerator.PreparedQuery query) {
        LOGGER.atDebug().addArgument((Object)query.sql()).addArgument(() -> query.parameters().stream().map(o -> o != null ? o.toString() : "NULL").collect(Collectors.joining("\n    ", "\n    ", ""))).setMessage("query: {}{}").log();
    }

    public static interface TransactionCallback {
        public boolean execute(Connection var1) throws SQLException;
    }

    public static interface Operation<T> {
        public T execute() throws SQLException;
    }
}

