/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroBatches {
    private MicroBatches() {
    }

    public static List<Pair<ManifestFile, Integer>> skippedManifestIndexesFromSnapshot(FileIO io, Snapshot snapshot, long startFileIndex, boolean scanAllFiles) {
        List manifests = scanAllFiles ? snapshot.dataManifests(io) : snapshot.dataManifests(io).stream().filter(m -> m.snapshotId().equals(snapshot.snapshotId())).collect(Collectors.toList());
        List<Pair<ManifestFile, Integer>> manifestIndexes = MicroBatches.indexManifests(manifests);
        return MicroBatches.skipManifests(manifestIndexes, startFileIndex);
    }

    public static CloseableIterable<FileScanTask> openManifestFile(FileIO io, Map<Integer, PartitionSpec> specsById, boolean caseSensitive, Snapshot snapshot, ManifestFile manifestFile, boolean scanAllFiles) {
        ManifestGroup manifestGroup = new ManifestGroup(io, (Iterable<ManifestFile>)ImmutableList.of((Object)manifestFile)).specsById(specsById).caseSensitive(caseSensitive);
        if (!scanAllFiles) {
            manifestGroup = manifestGroup.filterManifestEntries(entry -> entry.snapshotId().longValue() == snapshot.snapshotId() && entry.status() == ManifestEntry.Status.ADDED).ignoreDeleted();
        }
        return manifestGroup.planFiles();
    }

    private static List<Pair<ManifestFile, Integer>> indexManifests(List<ManifestFile> manifestFiles) {
        int currentFileIndex = 0;
        ArrayList manifestIndexes = Lists.newArrayList();
        for (ManifestFile manifest : manifestFiles) {
            manifestIndexes.add(Pair.of(manifest, currentFileIndex));
            currentFileIndex += manifest.addedFilesCount() + manifest.existingFilesCount();
        }
        return manifestIndexes;
    }

    private static List<Pair<ManifestFile, Integer>> skipManifests(List<Pair<ManifestFile, Integer>> indexedManifests, long startFileIndex) {
        if (startFileIndex == 0L) {
            return indexedManifests;
        }
        int manifestIndex = 0;
        for (Pair<ManifestFile, Integer> manifest : indexedManifests) {
            if ((long)manifest.second().intValue() > startFileIndex) break;
            ++manifestIndex;
        }
        return indexedManifests.subList(Math.max(manifestIndex - 1, 0), indexedManifests.size());
    }

    public static MicroBatchBuilder from(Snapshot snapshot, FileIO io) {
        return new MicroBatchBuilder(snapshot, io);
    }

    public static class MicroBatchBuilder {
        private static final Logger LOG = LoggerFactory.getLogger(MicroBatchBuilder.class);
        private final Snapshot snapshot;
        private final FileIO io;
        private boolean caseSensitive;
        private Map<Integer, PartitionSpec> specsById;

        private MicroBatchBuilder(Snapshot snapshot, FileIO io) {
            this.snapshot = snapshot;
            this.io = io;
            this.caseSensitive = true;
        }

        public MicroBatchBuilder caseSensitive(boolean sensitive) {
            this.caseSensitive = sensitive;
            return this;
        }

        public MicroBatchBuilder specsById(Map<Integer, PartitionSpec> specs) {
            this.specsById = specs;
            return this;
        }

        public MicroBatch generate(long startFileIndex, long targetSizeInBytes, boolean scanAllFiles) {
            return this.generate(startFileIndex, Iterables.size((Iterable)this.snapshot.addedDataFiles(this.io)), targetSizeInBytes, scanAllFiles);
        }

        public MicroBatch generate(long startFileIndex, long endFileIndex, long targetSizeInBytes, boolean scanAllFiles) {
            Preconditions.checkArgument((endFileIndex >= 0L ? 1 : 0) != 0, (Object)"endFileIndex is unexpectedly smaller than 0");
            Preconditions.checkArgument((startFileIndex >= 0L ? 1 : 0) != 0, (Object)"startFileIndex is unexpectedly smaller than 0");
            Preconditions.checkArgument((targetSizeInBytes > 0L ? 1 : 0) != 0, (Object)"targetSizeInBytes should be larger than 0");
            return this.generateMicroBatch(MicroBatches.skippedManifestIndexesFromSnapshot(this.io, this.snapshot, startFileIndex, scanAllFiles), startFileIndex, endFileIndex, targetSizeInBytes, scanAllFiles);
        }

        private MicroBatch generateMicroBatch(List<Pair<ManifestFile, Integer>> indexedManifests, long startFileIndex, long endFileIndex, long targetSizeInBytes, boolean scanAllFiles) {
            if (indexedManifests.isEmpty()) {
                return new MicroBatch(this.snapshot.snapshotId(), startFileIndex, endFileIndex, 0L, Collections.emptyList(), true);
            }
            long currentSizeInBytes = 0L;
            int currentFileIndex = 0;
            boolean isLastIndex = false;
            ArrayList tasks = Lists.newArrayList();
            for (int idx = 0; idx < indexedManifests.size(); ++idx) {
                currentFileIndex = indexedManifests.get(idx).second();
                try (CloseableIterable<FileScanTask> taskIterable = MicroBatches.openManifestFile(this.io, this.specsById, this.caseSensitive, this.snapshot, indexedManifests.get(idx).first(), scanAllFiles);
                     CloseableIterator taskIter = taskIterable.iterator();){
                    while (taskIter.hasNext()) {
                        FileScanTask task = (FileScanTask)taskIter.next();
                        if ((long)currentFileIndex >= startFileIndex && (long)currentFileIndex < endFileIndex) {
                            tasks.add(task);
                            currentSizeInBytes += task.length();
                        }
                        if (currentSizeInBytes < targetSizeInBytes && (long)(++currentFileIndex) < endFileIndex) continue;
                        break;
                    }
                    if (idx + 1 == indexedManifests.size() && !taskIter.hasNext()) {
                        isLastIndex = true;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Failed to close task iterable", (Throwable)ioe);
                }
                if (currentSizeInBytes < targetSizeInBytes) continue;
                if (tasks.size() <= 1 || currentSizeInBytes <= targetSizeInBytes) break;
                FileScanTask extraTask = (FileScanTask)tasks.remove(tasks.size() - 1);
                currentSizeInBytes -= extraTask.length();
                --currentFileIndex;
                isLastIndex = false;
                break;
            }
            return new MicroBatch(this.snapshot.snapshotId(), startFileIndex, currentFileIndex, currentSizeInBytes, tasks, isLastIndex);
        }
    }

    public static class MicroBatch {
        private final long snapshotId;
        private final long startFileIndex;
        private final long endFileIndex;
        private final long sizeInBytes;
        private final List<FileScanTask> tasks;
        private final boolean lastIndexOfSnapshot;

        private MicroBatch(long snapshotId, long startFileIndex, long endFileIndex, long sizeInBytes, List<FileScanTask> tasks, boolean lastIndexOfSnapshot) {
            this.snapshotId = snapshotId;
            this.startFileIndex = startFileIndex;
            this.endFileIndex = endFileIndex;
            this.sizeInBytes = sizeInBytes;
            this.tasks = tasks;
            this.lastIndexOfSnapshot = lastIndexOfSnapshot;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public long startFileIndex() {
            return this.startFileIndex;
        }

        public long endFileIndex() {
            return this.endFileIndex;
        }

        public long sizeInBytes() {
            return this.sizeInBytes;
        }

        public List<FileScanTask> tasks() {
            return this.tasks;
        }

        public boolean lastIndexOfSnapshot() {
            return this.lastIndexOfSnapshot;
        }
    }
}

