/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.PartitionStatisticsFileParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotParser;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StatisticsFileParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.JsonUtil;

public class TableMetadataParser {
    static final String FORMAT_VERSION = "format-version";
    static final String TABLE_UUID = "table-uuid";
    static final String LOCATION = "location";
    static final String LAST_SEQUENCE_NUMBER = "last-sequence-number";
    static final String LAST_UPDATED_MILLIS = "last-updated-ms";
    static final String LAST_COLUMN_ID = "last-column-id";
    static final String SCHEMA = "schema";
    static final String SCHEMAS = "schemas";
    static final String CURRENT_SCHEMA_ID = "current-schema-id";
    static final String PARTITION_SPEC = "partition-spec";
    static final String PARTITION_SPECS = "partition-specs";
    static final String DEFAULT_SPEC_ID = "default-spec-id";
    static final String LAST_PARTITION_ID = "last-partition-id";
    static final String DEFAULT_SORT_ORDER_ID = "default-sort-order-id";
    static final String SORT_ORDERS = "sort-orders";
    static final String PROPERTIES = "properties";
    static final String CURRENT_SNAPSHOT_ID = "current-snapshot-id";
    static final String REFS = "refs";
    static final String SNAPSHOTS = "snapshots";
    static final String SNAPSHOT_ID = "snapshot-id";
    static final String TIMESTAMP_MS = "timestamp-ms";
    static final String SNAPSHOT_LOG = "snapshot-log";
    static final String METADATA_FILE = "metadata-file";
    static final String METADATA_LOG = "metadata-log";
    static final String STATISTICS = "statistics";
    static final String PARTITION_STATISTICS = "partition-statistics";
    static final String NEXT_ROW_ID = "next-row-id";
    static final int MIN_NULL_CURRENT_SNAPSHOT_VERSION = 3;

    private TableMetadataParser() {
    }

    public static void overwrite(TableMetadata metadata, OutputFile outputFile) {
        TableMetadataParser.internalWrite(metadata, outputFile, true);
    }

    public static void write(TableMetadata metadata, OutputFile outputFile) {
        TableMetadataParser.internalWrite(metadata, outputFile, false);
    }

    public static void internalWrite(TableMetadata metadata, OutputFile outputFile, boolean overwrite) {
        boolean isGzip = Codec.fromFileName(outputFile.location()) == Codec.GZIP;
        PositionOutputStream stream = overwrite ? outputFile.createOrOverwrite() : outputFile.create();
        try (GZIPOutputStream ou = isGzip ? new GZIPOutputStream((OutputStream)stream) : stream;
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ou, StandardCharsets.UTF_8);){
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            TableMetadataParser.toJson(metadata, generator);
            generator.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write json to file: %s", new Object[]{outputFile.location()});
        }
    }

    public static String getFileExtension(String codecName) {
        return TableMetadataParser.getFileExtension(Codec.fromName(codecName));
    }

    public static String getFileExtension(Codec codec) {
        return codec.extension + ".metadata.json";
    }

    public static String getOldFileExtension(Codec codec) {
        return ".metadata.json" + codec.extension;
    }

    public static String toJson(TableMetadata metadata) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            TableMetadataParser.toJson(metadata, generator);
            generator.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to write json for: %s", new Object[]{metadata});
            }
        }
        writer.close();
        return string;
    }

    public static void toJson(TableMetadata metadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(FORMAT_VERSION, metadata.formatVersion());
        generator.writeStringField(TABLE_UUID, metadata.uuid());
        generator.writeStringField(LOCATION, metadata.location());
        if (metadata.formatVersion() > 1) {
            generator.writeNumberField(LAST_SEQUENCE_NUMBER, metadata.lastSequenceNumber());
        }
        generator.writeNumberField(LAST_UPDATED_MILLIS, metadata.lastUpdatedMillis());
        generator.writeNumberField(LAST_COLUMN_ID, metadata.lastColumnId());
        if (metadata.formatVersion() == 1) {
            generator.writeFieldName(SCHEMA);
            SchemaParser.toJson(metadata.schema(), generator);
        }
        generator.writeNumberField(CURRENT_SCHEMA_ID, metadata.currentSchemaId());
        generator.writeArrayFieldStart(SCHEMAS);
        for (Schema schema : metadata.schemas()) {
            SchemaParser.toJson(schema, generator);
        }
        generator.writeEndArray();
        if (metadata.formatVersion() == 1) {
            generator.writeFieldName(PARTITION_SPEC);
            PartitionSpecParser.toJsonFields(metadata.spec(), generator);
        }
        generator.writeNumberField(DEFAULT_SPEC_ID, metadata.defaultSpecId());
        generator.writeArrayFieldStart(PARTITION_SPECS);
        for (PartitionSpec partitionSpec : metadata.specs()) {
            PartitionSpecParser.toJson(partitionSpec, generator);
        }
        generator.writeEndArray();
        generator.writeNumberField(LAST_PARTITION_ID, metadata.lastAssignedPartitionId());
        generator.writeNumberField(DEFAULT_SORT_ORDER_ID, metadata.defaultSortOrderId());
        generator.writeArrayFieldStart(SORT_ORDERS);
        for (SortOrder sortOrder : metadata.sortOrders()) {
            SortOrderParser.toJson(sortOrder, generator);
        }
        generator.writeEndArray();
        JsonUtil.writeStringMap(PROPERTIES, metadata.properties(), generator);
        if (metadata.currentSnapshot() != null) {
            generator.writeNumberField(CURRENT_SNAPSHOT_ID, metadata.currentSnapshot().snapshotId());
        } else if (metadata.formatVersion() >= 3) {
            generator.writeNullField(CURRENT_SNAPSHOT_ID);
        } else {
            generator.writeNumberField(CURRENT_SNAPSHOT_ID, -1L);
        }
        if (metadata.formatVersion() >= 3) {
            generator.writeNumberField(NEXT_ROW_ID, metadata.nextRowId());
        }
        TableMetadataParser.toJson(metadata.refs(), generator);
        generator.writeArrayFieldStart(SNAPSHOTS);
        for (Snapshot snapshot : metadata.snapshots()) {
            SnapshotParser.toJson(snapshot, generator);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart(STATISTICS);
        for (StatisticsFile statisticsFile : metadata.statisticsFiles()) {
            StatisticsFileParser.toJson(statisticsFile, generator);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart(PARTITION_STATISTICS);
        for (PartitionStatisticsFile partitionStatisticsFile : metadata.partitionStatisticsFiles()) {
            PartitionStatisticsFileParser.toJson(partitionStatisticsFile, generator);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart(SNAPSHOT_LOG);
        for (HistoryEntry historyEntry : metadata.snapshotLog()) {
            generator.writeStartObject();
            generator.writeNumberField(TIMESTAMP_MS, historyEntry.timestampMillis());
            generator.writeNumberField(SNAPSHOT_ID, historyEntry.snapshotId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart(METADATA_LOG);
        for (TableMetadata.MetadataLogEntry metadataLogEntry : metadata.previousFiles()) {
            generator.writeStartObject();
            generator.writeNumberField(TIMESTAMP_MS, metadataLogEntry.timestampMillis());
            generator.writeStringField(METADATA_FILE, metadataLogEntry.file());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private static void toJson(Map<String, SnapshotRef> refs, JsonGenerator generator) throws IOException {
        generator.writeObjectFieldStart(REFS);
        for (Map.Entry<String, SnapshotRef> refEntry : refs.entrySet()) {
            generator.writeFieldName(refEntry.getKey());
            SnapshotRefParser.toJson(refEntry.getValue(), generator);
        }
        generator.writeEndObject();
    }

    public static TableMetadata read(FileIO io, String path) {
        return TableMetadataParser.read(io, io.newInputFile(path));
    }

    public static TableMetadata read(FileIO io, InputFile file) {
        TableMetadata tableMetadata;
        block8: {
            Codec codec = Codec.fromFileName(file.location());
            GZIPInputStream is = codec == Codec.GZIP ? new GZIPInputStream((InputStream)file.newStream()) : file.newStream();
            try {
                tableMetadata = TableMetadataParser.fromJson(file, (JsonNode)JsonUtil.mapper().readValue((InputStream)is, JsonNode.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read file: %s", new Object[]{file.location()});
                }
            }
            ((InputStream)is).close();
        }
        return tableMetadata;
    }

    public static TableMetadata fromJson(String json) {
        return TableMetadataParser.fromJson(null, json);
    }

    public static TableMetadata fromJson(String metadataLocation, String json) {
        return JsonUtil.parse(json, node -> TableMetadataParser.fromJson(metadataLocation, node));
    }

    public static TableMetadata fromJson(InputFile file, JsonNode node) {
        return TableMetadataParser.fromJson(file.location(), node);
    }

    public static TableMetadata fromJson(JsonNode node) {
        return TableMetadataParser.fromJson((String)null, node);
    }

    public static TableMetadata fromJson(String metadataLocation, JsonNode node) {
        Object snapshots;
        ImmutableList sortOrders;
        int defaultSortOrderId;
        JsonNode sortOrderArray;
        ImmutableList specs;
        int defaultSpecId;
        ImmutableList schemas;
        int currentSchemaId;
        Preconditions.checkArgument((boolean)node.isObject(), (String)"Cannot parse metadata from a non-object: %s", (Object)node);
        int formatVersion = JsonUtil.getInt(FORMAT_VERSION, node);
        Preconditions.checkArgument((formatVersion <= 3 ? 1 : 0) != 0, (String)"Cannot read unsupported version %s", (int)formatVersion);
        String uuid = JsonUtil.getStringOrNull(TABLE_UUID, node);
        String location = JsonUtil.getString(LOCATION, node);
        long lastSequenceNumber = formatVersion > 1 ? JsonUtil.getLong(LAST_SEQUENCE_NUMBER, node) : 0L;
        int lastAssignedColumnId = JsonUtil.getInt(LAST_COLUMN_ID, node);
        Schema schema = null;
        JsonNode schemaArray = node.get(SCHEMAS);
        if (schemaArray != null) {
            Preconditions.checkArgument((boolean)schemaArray.isArray(), (String)"Cannot parse schemas from non-array: %s", (Object)schemaArray);
            currentSchemaId = JsonUtil.getInt(CURRENT_SCHEMA_ID, node);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonNode schemaNode : schemaArray) {
                Schema current = SchemaParser.fromJson(schemaNode);
                if (current.schemaId() == currentSchemaId) {
                    schema = current;
                }
                builder.add((Object)current);
            }
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Cannot find schema with %s=%s from %s", (Object)CURRENT_SCHEMA_ID, (Object)currentSchemaId, (Object)SCHEMAS);
            schemas = builder.build();
        } else {
            Preconditions.checkArgument((formatVersion == 1 ? 1 : 0) != 0, (String)"%s must exist in format v%s", (Object)SCHEMAS, (int)formatVersion);
            schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, node));
            currentSchemaId = schema.schemaId();
            schemas = ImmutableList.of((Object)schema);
        }
        JsonNode specArray = node.get(PARTITION_SPECS);
        if (specArray != null) {
            Preconditions.checkArgument((boolean)specArray.isArray(), (String)"Cannot parse partition specs from non-array: %s", (Object)specArray);
            defaultSpecId = JsonUtil.getInt(DEFAULT_SPEC_ID, node);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonNode spec : specArray) {
                UnboundPartitionSpec unboundSpec = PartitionSpecParser.fromJson(spec);
                if (unboundSpec.specId() == defaultSpecId) {
                    builder.add((Object)unboundSpec.bind(schema));
                    continue;
                }
                builder.add((Object)unboundSpec.bindUnchecked(schema));
            }
            specs = builder.build();
        } else {
            Preconditions.checkArgument((formatVersion == 1 ? 1 : 0) != 0, (String)"%s must exist in format v%s", (Object)PARTITION_SPECS, (int)formatVersion);
            defaultSpecId = 0;
            specs = ImmutableList.of((Object)PartitionSpecParser.fromJsonFields(schema, 0, JsonUtil.get(PARTITION_SPEC, node)));
        }
        Integer lastAssignedPartitionId = JsonUtil.getIntOrNull(LAST_PARTITION_ID, node);
        if (lastAssignedPartitionId == null) {
            Preconditions.checkArgument((formatVersion == 1 ? 1 : 0) != 0, (String)"%s must exist in format v%s", (Object)LAST_PARTITION_ID, (int)formatVersion);
            lastAssignedPartitionId = specs.stream().mapToInt(PartitionSpec::lastAssignedFieldId).max().orElse(PartitionSpec.unpartitioned().lastAssignedFieldId());
        }
        if ((sortOrderArray = node.get(SORT_ORDERS)) != null) {
            defaultSortOrderId = JsonUtil.getInt(DEFAULT_SORT_ORDER_ID, node);
            ImmutableList.Builder sortOrdersBuilder = ImmutableList.builder();
            for (JsonNode sortOrder : sortOrderArray) {
                sortOrdersBuilder.add((Object)SortOrderParser.fromJson(schema, sortOrder, defaultSortOrderId));
            }
            sortOrders = sortOrdersBuilder.build();
        } else {
            Preconditions.checkArgument((formatVersion == 1 ? 1 : 0) != 0, (String)"%s must exist in format v%s", (Object)SORT_ORDERS, (int)formatVersion);
            SortOrder defaultSortOrder = SortOrder.unsorted();
            sortOrders = ImmutableList.of((Object)defaultSortOrder);
            defaultSortOrderId = defaultSortOrder.orderId();
        }
        Object properties = node.has(PROPERTIES) ? JsonUtil.getStringMap(PROPERTIES, node) : ImmutableMap.of();
        Long currentSnapshotId = JsonUtil.getLongOrNull(CURRENT_SNAPSHOT_ID, node);
        if (currentSnapshotId == null) {
            currentSnapshotId = -1L;
        }
        long lastRowId = formatVersion >= 3 ? JsonUtil.getLong(NEXT_ROW_ID, node) : 0L;
        long lastUpdatedMillis = JsonUtil.getLong(LAST_UPDATED_MILLIS, node);
        ImmutableMap refs = node.has(REFS) ? TableMetadataParser.refsFromJson(node.get(REFS)) : (currentSnapshotId != -1L ? ImmutableMap.of((Object)"main", (Object)SnapshotRef.branchBuilder((long)currentSnapshotId).build()) : ImmutableMap.of());
        if (node.has(SNAPSHOTS)) {
            JsonNode snapshotArray = JsonUtil.get(SNAPSHOTS, node);
            Preconditions.checkArgument((boolean)snapshotArray.isArray(), (String)"Cannot parse snapshots from non-array: %s", (Object)snapshotArray);
            snapshots = Lists.newArrayListWithExpectedSize((int)snapshotArray.size());
            Iterator iterator = snapshotArray.elements();
            while (iterator.hasNext()) {
                snapshots.add(SnapshotParser.fromJson((JsonNode)iterator.next()));
            }
        } else {
            snapshots = ImmutableList.of();
        }
        Object statisticsFiles = node.has(STATISTICS) ? TableMetadataParser.statisticsFilesFromJson(node.get(STATISTICS)) : ImmutableList.of();
        Object partitionStatisticsFiles = node.has(PARTITION_STATISTICS) ? TableMetadataParser.partitionStatsFilesFromJson(node.get(PARTITION_STATISTICS)) : ImmutableList.of();
        ImmutableList.Builder entries = ImmutableList.builder();
        if (node.has(SNAPSHOT_LOG)) {
            Iterator logIterator = node.get(SNAPSHOT_LOG).elements();
            while (logIterator.hasNext()) {
                JsonNode entryNode = (JsonNode)logIterator.next();
                entries.add((Object)new TableMetadata.SnapshotLogEntry(JsonUtil.getLong(TIMESTAMP_MS, entryNode), JsonUtil.getLong(SNAPSHOT_ID, entryNode)));
            }
        }
        ImmutableList.Builder metadataEntries = ImmutableList.builder();
        if (node.has(METADATA_LOG)) {
            Iterator logIterator = node.get(METADATA_LOG).elements();
            while (logIterator.hasNext()) {
                JsonNode entryNode = (JsonNode)logIterator.next();
                metadataEntries.add((Object)new TableMetadata.MetadataLogEntry(JsonUtil.getLong(TIMESTAMP_MS, entryNode), JsonUtil.getString(METADATA_FILE, entryNode)));
            }
        }
        return new TableMetadata(metadataLocation, formatVersion, uuid, location, lastSequenceNumber, lastUpdatedMillis, lastAssignedColumnId, currentSchemaId, (List<Schema>)schemas, defaultSpecId, (List<PartitionSpec>)specs, lastAssignedPartitionId, defaultSortOrderId, (List<SortOrder>)sortOrders, (Map<String, String>)properties, currentSnapshotId, (List<Snapshot>)snapshots, null, (List<HistoryEntry>)entries.build(), (List<TableMetadata.MetadataLogEntry>)metadataEntries.build(), (Map<String, SnapshotRef>)refs, (List<StatisticsFile>)statisticsFiles, (List<PartitionStatisticsFile>)partitionStatisticsFiles, lastRowId, (List<MetadataUpdate>)ImmutableList.of());
    }

    private static Map<String, SnapshotRef> refsFromJson(JsonNode refMap) {
        Preconditions.checkArgument((boolean)refMap.isObject(), (String)"Cannot parse refs from non-object: %s", (Object)refMap);
        ImmutableMap.Builder refsBuilder = ImmutableMap.builder();
        Iterator refNames = refMap.fieldNames();
        while (refNames.hasNext()) {
            String refName = (String)refNames.next();
            JsonNode refNode = JsonUtil.get(refName, refMap);
            Preconditions.checkArgument((boolean)refNode.isObject(), (String)"Cannot parse ref %s from non-object: %s", (Object)refName, (Object)refMap);
            SnapshotRef ref = SnapshotRefParser.fromJson(refNode);
            refsBuilder.put((Object)refName, (Object)ref);
        }
        return refsBuilder.build();
    }

    private static List<StatisticsFile> statisticsFilesFromJson(JsonNode statisticsFilesList) {
        Preconditions.checkArgument((boolean)statisticsFilesList.isArray(), (String)"Cannot parse statistics files from non-array: %s", (Object)statisticsFilesList);
        ImmutableList.Builder statisticsFilesBuilder = ImmutableList.builder();
        for (JsonNode statisticsFile : statisticsFilesList) {
            statisticsFilesBuilder.add((Object)StatisticsFileParser.fromJson(statisticsFile));
        }
        return statisticsFilesBuilder.build();
    }

    private static List<PartitionStatisticsFile> partitionStatsFilesFromJson(JsonNode filesList) {
        Preconditions.checkArgument((boolean)filesList.isArray(), (String)"Cannot parse partition statistics files from non-array: %s", (Object)filesList);
        ImmutableList.Builder statsFileBuilder = ImmutableList.builder();
        for (JsonNode partitionStatsFile : filesList) {
            statsFileBuilder.add((Object)PartitionStatisticsFileParser.fromJson(partitionStatsFile));
        }
        return statsFileBuilder.build();
    }

    public static enum Codec {
        NONE(""),
        GZIP(".gz");

        private final String extension;

        private Codec(String extension) {
            this.extension = extension;
        }

        public static Codec fromName(String codecName) {
            Preconditions.checkArgument((codecName != null ? 1 : 0) != 0, (Object)"Codec name is null");
            try {
                return Codec.valueOf(codecName.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid codec name: %s", codecName), e);
            }
        }

        public static Codec fromFileName(String fileName) {
            Preconditions.checkArgument((boolean)fileName.contains(".metadata.json"), (String)"%s is not a valid metadata file", (Object)fileName);
            if (fileName.endsWith(".metadata.json.gz")) {
                return GZIP;
            }
            String fileNameWithoutSuffix = fileName.substring(0, fileName.lastIndexOf(".metadata.json"));
            if (fileNameWithoutSuffix.endsWith(Codec.GZIP.extension)) {
                return GZIP;
            }
            return NONE;
        }
    }
}

