/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.VariantLogicalType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class AvroWithPartnerVisitor<P, R> {
    private final Deque<String> recordLevels = Lists.newLinkedList();

    public R record(P partner, Schema record, List<R> fieldResults) {
        return null;
    }

    public R union(P partner, Schema union, List<R> optionResults) {
        return null;
    }

    public R array(P partner, Schema array, R elementResult) {
        return null;
    }

    public R arrayMap(P partner, Schema map, R keyResult, R valueResult) {
        return null;
    }

    public R map(P partner, Schema map, R valueResult) {
        return null;
    }

    public R variant(P partner, R metadataResult, R valueResult) {
        throw new UnsupportedOperationException("Visitor does not support variant");
    }

    public R primitive(P partner, Schema primitive) {
        return null;
    }

    public static <P, R> R visit(P partner, Schema schema, AvroWithPartnerVisitor<P, R> visitor, PartnerAccessors<P> accessors) {
        switch (schema.getType()) {
            case RECORD: {
                if (schema.getLogicalType() instanceof VariantLogicalType) {
                    return AvroWithPartnerVisitor.visitVariant(partner, schema, visitor, accessors);
                }
                return AvroWithPartnerVisitor.visitRecord(partner, schema, visitor, accessors);
            }
            case UNION: {
                return AvroWithPartnerVisitor.visitUnion(partner, schema, visitor, accessors);
            }
            case ARRAY: {
                return AvroWithPartnerVisitor.visitArray(partner, schema, visitor, accessors);
            }
            case MAP: {
                return visitor.map(partner, schema, AvroWithPartnerVisitor.visit(partner != null ? (P)accessors.mapValuePartner(partner) : null, schema.getValueType(), visitor, accessors));
            }
        }
        return visitor.primitive(partner, schema);
    }

    private static <P, R> R visitVariant(P partner, Schema variant, AvroWithPartnerVisitor<P, R> visitor, PartnerAccessors<P> accessors) {
        String recordName = variant.getFullName();
        Preconditions.checkState((!visitor.recordLevels.contains(recordName) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object)recordName);
        visitor.recordLevels.push(recordName);
        R metadataResult = AvroWithPartnerVisitor.visit(null, variant.getField("metadata").schema(), visitor, accessors);
        R valueResult = AvroWithPartnerVisitor.visit(null, variant.getField("value").schema(), visitor, accessors);
        visitor.recordLevels.pop();
        return visitor.variant(partner, metadataResult, valueResult);
    }

    private static <P, R> R visitRecord(P partnerStruct, Schema record, AvroWithPartnerVisitor<P, R> visitor, PartnerAccessors<P> accessors) {
        String recordName = record.getFullName();
        Preconditions.checkState((!visitor.recordLevels.contains(recordName) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object)recordName);
        visitor.recordLevels.push(recordName);
        List fields = record.getFields();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (int pos = 0; pos < fields.size(); ++pos) {
            Schema.Field field = (Schema.Field)fields.get(pos);
            Integer fieldId = AvroSchemaUtil.fieldId(field);
            P fieldPartner = partnerStruct != null && fieldId != null ? (P)accessors.fieldPartner(partnerStruct, fieldId, field.name()) : null;
            results.add(AvroWithPartnerVisitor.visit(fieldPartner, field.schema(), visitor, accessors));
        }
        visitor.recordLevels.pop();
        return visitor.record(partnerStruct, record, results);
    }

    private static <P, R> R visitUnion(P partner, Schema union, AvroWithPartnerVisitor<P, R> visitor, PartnerAccessors<P> accessors) {
        Preconditions.checkArgument((boolean)AvroSchemaUtil.isOptionSchema(union), (String)"Cannot visit non-option union: %s", (Object)union);
        List types = union.getTypes();
        ArrayList options = Lists.newArrayListWithExpectedSize((int)types.size());
        for (Schema branch : types) {
            options.add(AvroWithPartnerVisitor.visit(partner, branch, visitor, accessors));
        }
        return visitor.union(partner, union, options);
    }

    private static <P, R> R visitArray(P partnerArray, Schema array, AvroWithPartnerVisitor<P, R> visitor, PartnerAccessors<P> accessors) {
        if (array.getLogicalType() instanceof LogicalMap) {
            Preconditions.checkState((boolean)AvroSchemaUtil.isKeyValueSchema(array.getElementType()), (String)"Cannot visit invalid logical map type: %s", (Object)array);
            List keyValueFields = array.getElementType().getFields();
            return visitor.arrayMap(partnerArray, array, AvroWithPartnerVisitor.visit(partnerArray != null ? (P)accessors.mapKeyPartner(partnerArray) : null, ((Schema.Field)keyValueFields.get(0)).schema(), visitor, accessors), AvroWithPartnerVisitor.visit(partnerArray != null ? (P)accessors.mapValuePartner(partnerArray) : null, ((Schema.Field)keyValueFields.get(1)).schema(), visitor, accessors));
        }
        return visitor.array(partnerArray, array, AvroWithPartnerVisitor.visit(partnerArray != null ? (P)accessors.listElementPartner(partnerArray) : null, array.getElementType(), visitor, accessors));
    }

    public static class FieldIDAccessors
    implements PartnerAccessors<Type> {
        private static final FieldIDAccessors INSTANCE = new FieldIDAccessors();

        public static FieldIDAccessors get() {
            return INSTANCE;
        }

        @Override
        public Type fieldPartner(Type partner, Integer fieldId, String name) {
            Types.NestedField field = partner.asStructType().field(fieldId.intValue());
            return field != null ? field.type() : null;
        }

        @Override
        public Type mapKeyPartner(Type partner) {
            return partner.asMapType().keyType();
        }

        @Override
        public Type mapValuePartner(Type partner) {
            return partner.asMapType().valueType();
        }

        @Override
        public Type listElementPartner(Type partner) {
            return partner.asListType().elementType();
        }
    }

    public static interface PartnerAccessors<P> {
        public P fieldPartner(P var1, Integer var2, String var3);

        public P mapKeyPartner(P var1);

        public P mapValuePartner(P var1);

        public P listElementPartner(P var1);
    }
}

