/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddressKind;

public class SpecialAddress {
    public static final MailAddress SENDER = AddressMarker.SENDER;
    public static final MailAddress REVERSE_PATH = AddressMarker.REVERSE_PATH;
    public static final MailAddress FROM = AddressMarker.FROM;
    public static final MailAddress REPLY_TO = AddressMarker.REPLY_TO;
    public static final MailAddress TO = AddressMarker.TO;
    public static final MailAddress RECIPIENTS = AddressMarker.RECIPIENTS;
    public static final MailAddress DELETE = AddressMarker.DELETE;
    public static final MailAddress UNALTERED = AddressMarker.UNALTERED;
    public static final MailAddress NULL = AddressMarker.NULL;

    public static boolean isSpecialAddress(MailAddress mailAddress) {
        return mailAddress.getDomain().equals((Object)AddressMarker.ADDRESS_MARKER);
    }

    public static class AddressMarker {
        public static final Domain ADDRESS_MARKER = Domain.of((String)"address.marker");
        public static final MailAddress SENDER = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.SENDER, ADDRESS_MARKER);
        public static final MailAddress REVERSE_PATH = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.REVERSE_PATH, ADDRESS_MARKER);
        public static final MailAddress FROM = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.FROM, ADDRESS_MARKER);
        public static final MailAddress REPLY_TO = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.REPLY_TO, ADDRESS_MARKER);
        public static final MailAddress TO = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.TO, ADDRESS_MARKER);
        public static final MailAddress RECIPIENTS = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.RECIPIENTS, ADDRESS_MARKER);
        public static final MailAddress DELETE = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.DELETE, ADDRESS_MARKER);
        public static final MailAddress UNALTERED = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.UNALTERED, ADDRESS_MARKER);
        public static final MailAddress NULL = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.NULL, ADDRESS_MARKER);

        private static MailAddress mailAddressUncheckedException(SpecialAddressKind kind, Domain domain) {
            try {
                return new MailAddress(kind.getValue(), domain);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

