/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.util.Set;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.json.DTOModule;
import org.apache.james.server.blob.deduplication.BlobGCTask;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;

public class BlobGCTaskDTO
implements TaskDTO {
    private final String bucketName;
    private final int expectedBlobCount;
    private final double associatedProbability;
    private final String type;

    public BlobGCTaskDTO(@JsonProperty(value="bucketName") String bucketName, @JsonProperty(value="expectedBlobCount") int expectedBlobCount, @JsonProperty(value="associatedProbability") double associatedProbability, @JsonProperty(value="type") String type) {
        this.bucketName = bucketName;
        this.expectedBlobCount = expectedBlobCount;
        this.associatedProbability = associatedProbability;
        this.type = type;
    }

    public static TaskDTOModule<BlobGCTask, BlobGCTaskDTO> module(BlobStoreDAO blobStoreDAO, GenerationAwareBlobId.Factory generationAwareBlobIdFactory, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, Set<BlobReferenceSource> blobReferenceSources, Clock clock) {
        return (TaskDTOModule)DTOModule.forDomainObject(BlobGCTask.class).convertToDTO(BlobGCTaskDTO.class).toDomainObjectConverter(dto -> BlobGCTask.builder().blobStoreDAO(blobStoreDAO).generationAwareBlobIdFactory(generationAwareBlobIdFactory).generationAwareBlobIdConfiguration(generationAwareBlobIdConfiguration).blobReferenceSource(blobReferenceSources).bucketName(BucketName.of((String)dto.bucketName)).clock(clock).expectedBlobCount(dto.expectedBlobCount).associatedProbability(dto.associatedProbability)).toDTOConverter((domain, type) -> new BlobGCTaskDTO(domain.getBucketName().asString(), domain.getExpectedBlobCount(), domain.getAssociatedProbability(), type)).typeName(BlobGCTask.TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public String getType() {
        return this.type;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public int getExpectedBlobCount() {
        return this.expectedBlobCount;
    }

    public double getAssociatedProbability() {
        return this.associatedProbability;
    }
}

