/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ClearMailboxContentTask;
import org.apache.james.webadmin.service.UserMailboxesService;
import org.apache.james.webadmin.validation.MailboxName;

public class ClearMailboxContentTaskDTO
implements TaskDTO {
    private final String type;
    private final String username;
    private final String mailboxName;

    public ClearMailboxContentTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username, @JsonProperty(value="mailboxName") String mailboxName) {
        this.type = type;
        this.username = username;
        this.mailboxName = mailboxName;
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public static TaskDTOModule<ClearMailboxContentTask, ClearMailboxContentTaskDTO> module(UserMailboxesService userMailboxesService) {
        return (TaskDTOModule)DTOModule.forDomainObject(ClearMailboxContentTask.class).convertToDTO(ClearMailboxContentTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(userMailboxesService)).toDTOConverter(ClearMailboxContentTaskDTO::toDTO).typeName(ClearMailboxContentTask.TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public ClearMailboxContentTask fromDTO(UserMailboxesService userMailboxesService) {
        return new ClearMailboxContentTask(Username.of((String)this.username), new MailboxName(this.mailboxName), userMailboxesService);
    }

    public static ClearMailboxContentTaskDTO toDTO(ClearMailboxContentTask domainObject, String typeName) {
        return new ClearMailboxContentTaskDTO(typeName, domainObject.getUsername().asString(), domainObject.getMailboxName().asString());
    }
}

