/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.DurationCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.HeadAndTailSizeCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.TimeWindowCollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ToolDefaultCollectSupportDataLogCaptureWindow;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class CollectSupportDataLogCaptureWindow
implements Serializable {
    protected static final byte TYPE_TOOL_DEFAULT = -128;
    protected static final byte TYPE_DURATION = -127;
    protected static final byte TYPE_TIME_WINDOW = -94;
    protected static final byte TYPE_HEAD_AND_TAIL_SIZE = -93;
    private static final long serialVersionUID = 6491461694423982840L;

    @NotNull
    public static CollectSupportDataLogCaptureWindow decode(@NotNull ASN1Element e) throws LDAPException {
        switch (e.getType()) {
            case -128: {
                return ToolDefaultCollectSupportDataLogCaptureWindow.decodeInternal(e);
            }
            case -127: {
                return DurationCollectSupportDataLogCaptureWindow.decodeInternal(e);
            }
            case -94: {
                return TimeWindowCollectSupportDataLogCaptureWindow.decodeInternal(e);
            }
            case -93: {
                return HeadAndTailSizeCollectSupportDataLogCaptureWindow.decodeInternal(e);
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_LOG_WINDOW_CANNOT_DECODE.get(StaticUtils.toHex(e.getType())));
    }

    @NotNull
    public abstract ASN1Element encode();

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);
}

