/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.security.KeyStore;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import nl.altindag.ssl.util.OSCertificateUtils;
import nl.altindag.ssl.util.internal.CollectorsUtils;

final class WindowsCertificateUtils
extends OSCertificateUtils {
    private static WindowsCertificateUtils INSTANCE;

    WindowsCertificateUtils() {
    }

    @Override
    List<KeyStore> getTrustStores() {
        return Stream.of("Windows-ROOT", "Windows-ROOT-LOCALMACHINE", "Windows-ROOT-CURRENTUSER", "Windows-MY", "Windows-MY-CURRENTUSER", "Windows-MY-LOCALMACHINE").map(keystoreType -> this.createKeyStoreIfAvailable((String)keystoreType, null)).filter(Optional::isPresent).map(Optional::get).collect(CollectorsUtils.toUnmodifiableList());
    }

    static WindowsCertificateUtils getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WindowsCertificateUtils();
        }
        return INSTANCE;
    }
}

