/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Map;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.IdResponse;

public class IdResponseEncoder
implements ImapResponseEncoder<IdResponse> {
    @Override
    public Class<IdResponse> acceptableMessages() {
        return IdResponse.class;
    }

    @Override
    public void encode(IdResponse existsResponse, ImapResponseComposer composer) throws IOException {
        composer.untagged().message("ID");
        if (existsResponse.fields().isEmpty()) {
            composer.nil();
        } else {
            composer.openParen();
            for (Map.Entry<String, String> keyValue : existsResponse.fields().entrySet()) {
                composer.quote(keyValue.getKey());
                composer.quote(keyValue.getValue());
            }
            composer.closeParen();
        }
        composer.end();
    }
}

