/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.elements.impl;

import java.io.IOException;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Content;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ContentImpl
implements Content,
AtomElement {
    private String _mimeType;
    private String _language;
    private String _mode;
    private String _content;
    private String _tagname = "content";

    public ContentImpl() {
        this(null, "content");
    }

    public ContentImpl(String tagname) {
        this(null, tagname);
    }

    public ContentImpl(String content, String tagname) {
        this._tagname = tagname;
        this._content = content;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public String getMode() {
        return this._mode;
    }

    public void setMode(String mode) {
        this._mode = mode;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public String getBody() {
        return this._content;
    }

    public void setBody(String content) {
        this._content = content;
    }

    public void setTagName(String tagame) {
        this._tagname = tagame;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append(this._tagname);
        if (this._mimeType != null) {
            buffer.append(" ").append("type").append("=\"").append(this._mimeType).append("\"");
        }
        if (this._mode != null) {
            buffer.append(" ").append("mode").append("=\"").append(this._mode).append("\"");
        }
        if (this._language != null) {
            buffer.append(" ").append("xml:lang").append("=\"").append(this._language).append("\"");
        }
        buffer.append(">");
        if (this._tagname.equals("content")) {
            buffer.append("<![CDATA[").append(this._content).append("]]>");
        } else {
            buffer.append(this._content);
        }
        buffer.append("</").append(this._tagname).append(">");
        return buffer.toString();
    }

    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        int eventType = parser.getEventType();
        StringBuffer buffer = new StringBuffer();
        do {
            if (eventType == 2 && this._tagname.equals(parser.getName())) {
                this.processDocumentAttributes(parser);
            } else {
                buffer.append(parser.getText());
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (eventType != 3 || !this._tagname.equals(parser.getName()));
        this._content = buffer.toString();
    }

    private void processDocumentAttributes(XmlPullParser parser) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("lang")) {
                this.setLanguage(parser.getAttributeValue(x));
                continue;
            }
            if (parser.getAttributeName(x).equals("mode")) {
                this.setMode(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeName(x).equals("type")) continue;
            this.setMimeType(parser.getAttributeValue(x));
        }
    }
}

